/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.service.FileTagService;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FileTagServiceImpl
implements FileTagService {
    private static final String SEMICOLON = ";";
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;

    public void addTag(String bucket, String fileInfoId, String tag) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        String oldTags = fileInfo.getTag();
        if (StringUtils.hasLength((String)oldTags)) {
            tag = oldTags + SEMICOLON + tag;
        }
        fileInfo.setTag(tag);
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void deleteTag(String bucket, String fileInfoId, String tag) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        String[] tags = fileInfo.getTag().split(SEMICOLON);
        String newTags = Arrays.stream(tags).filter(o -> !tag.equals(o)).collect(Collectors.joining(SEMICOLON));
        fileInfo.setTag(newTags);
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void deleteTag(String bucket, String fileInfoId) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        fileInfo.setTag(null);
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void replaceTag(String bucket, String fileInfoId, String tag) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        fileInfo.setTag(tag);
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public String getTag(String bucket, String fileInfoId) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        return fileInfo.getTag() == null ? "" : fileInfo.getTag();
    }
}

