/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.ImageInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.ImageResult;
import com.digiwin.dap.middleware.dmc.obsolete.entity.ImageCacheFile;
import com.digiwin.dap.middleware.dmc.obsolete.service.HandleImageService;
import com.digiwin.dap.middleware.dmc.obsolete.service.ImageCacheFileService;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.util.ImageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleImageServiceImpl
implements HandleImageService {
    @Autowired
    private FileUploadService uploadService;
    @Autowired
    private FileDownloadService downloadService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private ImageCacheFileService imageCacheFileService;

    public ImageResult getProportionallyProcessedImage(String bucketName, String fileId, ImageInfo imageInfo, String condition) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucketName, fileId);
        byte[] oldImage = this.downloadService.downloadToBytes(bucketName, fileInfo);
        byte[] newImage = ImageUtil.scaleImage((byte[])oldImage, (ImageInfo)imageInfo);
        return this.handleImage(fileInfo, bucketName, imageInfo, condition, newImage);
    }

    public ImageResult getProcessedImage(String bucketName, String fileId, ImageInfo imageInfo, String condition) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucketName, fileId);
        byte[] imageByte = this.downloadService.downloadToBytes(bucketName, fileInfo);
        byte[] newImage = ImageUtil.scaleCreate((byte[])imageByte, (ImageInfo)imageInfo);
        return this.handleImage(fileInfo, bucketName, imageInfo, condition, newImage);
    }

    public ImageResult getProcessedImageClip(String bucketName, String fileId, ImageInfo imageInfo, String condition) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucketName, fileId);
        byte[] imageByte = this.downloadService.downloadToBytes(bucketName, fileInfo);
        byte[] newImage = ImageUtil.createImageClip((byte[])imageByte, (ImageInfo)imageInfo);
        return this.handleImage(fileInfo, bucketName, imageInfo, condition, newImage);
    }

    private ImageResult handleImage(FileInfo fileInfo, String bucketName, ImageInfo imageInfo, String condition, byte[] newImage) {
        String[] fileName = fileInfo.getFileName().split("\\.");
        String imageName = imageInfo.isRound() ? fileName[0] + ".png" : fileName[0] + "." + imageInfo.getFormat();
        FileInfo dualFileInfo = FileInfo.dual((String)imageName, null);
        this.uploadService.uploadFromBytes(bucketName, dualFileInfo, newImage);
        ImageCacheFile imageCacheFile = new ImageCacheFile();
        imageCacheFile.setCondition(condition);
        imageCacheFile.setImageId(fileInfo.getId().toString());
        imageCacheFile.setNewImageId(dualFileInfo.getFileId().toString());
        this.imageCacheFileService.insert(imageCacheFile, bucketName);
        ImageResult imageResult = new ImageResult();
        imageResult.setFileName(imageName);
        imageResult.setImageBytes(newImage);
        return imageResult;
    }
}

