/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.entity.ImageCacheFile;
import com.digiwin.dap.middleware.dmc.obsolete.service.ImageCacheFileService;
import com.digiwin.dap.middleware.dmc.obsolete.service.base.AbstractDocumentService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImageCacheFileServiceImpl
extends AbstractDocumentService<ImageCacheFile>
implements ImageCacheFileService {
    private static final String IMAGE_CACHE_FILES_CONDITION = "condition";
    private static final String IMAGE_FILE_ID = "imageId";
    @Autowired
    private FileUploadService fileUploadService;

    protected String getCollectionName() {
        return ".image_cache_files";
    }

    protected Class<ImageCacheFile> getEntityClass() {
        return ImageCacheFile.class;
    }

    public ImageCacheFile findCacheFile(String imageId, String condition, String bucket) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> obj = new ArrayList<BasicDBObject>();
        obj.add(new BasicDBObject(IMAGE_CACHE_FILES_CONDITION, (Object)condition));
        obj.add(new BasicDBObject(IMAGE_FILE_ID, (Object)imageId));
        andQuery.put((Object)"$and", obj);
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        return (ImageCacheFile)mongoCollection.find((Bson)andQuery).first();
    }

    public String insert(ImageCacheFile imageCacheFile, String bucket) {
        return super.insert(bucket, (UuIdEntity)imageCacheFile);
    }

    public void clean(String bucket) {
        List imageCacheFiles = this.imageCacheFiles(bucket);
        for (ImageCacheFile cacheFile : imageCacheFiles) {
            FileInfo fileInfo = FileInfo.dual((String)"", (String)cacheFile.getNewImageId());
            fileInfo.setId(IdUtil.uuid((String)cacheFile.getImageId()));
            this.fileUploadService.deleteFile(bucket, fileInfo);
        }
        MongoCollection mongoCollection = super.getLoginUserDocuments(bucket);
        mongoCollection.drop();
    }

    public List<ImageCacheFile> imageCacheFiles(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        MongoCursor result = mongoCollection.find().iterator();
        ArrayList<ImageCacheFile> sharedFiles = new ArrayList<ImageCacheFile>();
        while (result.hasNext()) {
            sharedFiles.add((ImageCacheFile)result.next());
        }
        return sharedFiles;
    }

    public void deleteByImageId(String bucket, String imageId) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        List imageCacheFile = this.findCacheFileByImageId(imageId, bucket);
        if (!imageCacheFile.isEmpty()) {
            for (ImageCacheFile cacheFile : imageCacheFile) {
                FileInfo fileInfo = FileInfo.dual((String)"", (String)cacheFile.getNewImageId());
                fileInfo.setId(IdUtil.uuid((String)cacheFile.getImageId()));
                this.fileUploadService.deleteFile(bucket, fileInfo);
            }
            mongoCollection.deleteMany(Filters.eq((String)IMAGE_FILE_ID, (Object)imageId));
        }
    }

    public List<ImageCacheFile> findCacheFileByImageId(String imageId, String bucket) {
        BasicDBObject andQuery = new BasicDBObject((Map)new BasicDBObject(IMAGE_FILE_ID, (Object)imageId));
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        MongoCursor result = mongoCollection.find((Bson)andQuery).iterator();
        ArrayList<ImageCacheFile> imageCacheFiles = new ArrayList<ImageCacheFile>();
        while (result.hasNext()) {
            imageCacheFiles.add((ImageCacheFile)result.next());
        }
        return imageCacheFiles;
    }
}

