/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.ChangeInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.ChangeQuery;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.LogFieldPath;
import com.digiwin.dap.middleware.dmc.obsolete.entity.CompareInfo;
import com.digiwin.dap.middleware.dmc.obsolete.service.OperationLogService;
import com.digiwin.dap.middleware.dmc.obsolete.service.base.AbstractDocumentService;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OperationLogServiceImpl
extends AbstractDocumentService<CompareInfo>
implements OperationLogService {
    private Logger logger = LoggerFactory.getLogger(OperationLogServiceImpl.class);
    private static final String PRIMARY_KRY_NAME = "primaryKey";
    private static final String EDIT_TIME = "editTime";
    private static final String LINKED_HASH_MAP = "LinkedHashMap";
    private static final String ARRAY_LIST = "ArrayList";

    protected String getCollectionName() {
        return null;
    }

    protected Class<CompareInfo> getEntityClass() {
        return CompareInfo.class;
    }

    public String insert(String bucket, CompareInfo compareInfo, String collectionName) {
        return super.insert(bucket, (UuIdEntity)compareInfo, collectionName);
    }

    public List<ChangeInfo> getModifyContent(Map<String, Object> sourceMap, Map<String, Object> targetMap, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        ArrayList<ChangeInfo> changeList = new ArrayList<ChangeInfo>();
        try {
            sourceMap.forEach((k, v) -> {
                Object targetValue = targetMap.get(k);
                if (targetValue != null && !Objects.equals(v, targetValue)) {
                    if (LINKED_HASH_MAP.equals(targetValue.getClass().getSimpleName())) {
                        ChangeInfo changeInfo = this.complexPropertyInfo(k, v, targetValue, logFieldList, primaryKeyList, logFieldPath);
                        if (changeInfo == null) {
                            return;
                        }
                        changeList.add(changeInfo);
                    } else if (ARRAY_LIST.equals(targetValue.getClass().getSimpleName())) {
                        ChangeInfo changeInfo = this.collectionPropertyInfo(k, v, targetValue, logFieldList, primaryKeyList, logFieldPath);
                        if (changeInfo == null || changeInfo.getChangedSet().size() == 0) {
                            return;
                        }
                        changeList.add(changeInfo);
                    } else {
                        ChangeInfo changeInfo = this.simplePropertyInfo(k, v, targetValue, logFieldList, logFieldPath);
                        if (changeInfo == null) {
                            return;
                        }
                        changeList.add(changeInfo);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return changeList;
    }

    public List<CompareInfo> getCompareInfoList(String bucket, String source, String primaryKey, int count, ChangeQuery changeQuery) {
        MongoCollection mongoCollection = super.getLoginUserDocuments(bucket, ".".concat(source));
        ArrayList<CompareInfo> compareInfoS = new ArrayList<CompareInfo>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)PRIMARY_KRY_NAME).is((Object)primaryKey));
        if (changeQuery != null) {
            Criteria c = new Criteria();
            if (!StringUtils.isEmpty((Object)changeQuery.getEditUserId())) {
                c.orOperator(new Criteria[]{Criteria.where((String)"editUserId").regex(changeQuery.getEditUserId()), Criteria.where((String)"editUserName").regex(changeQuery.getEditUserId())});
            }
            if (!StringUtils.isEmpty((Object)changeQuery.getBeginTime()) && StringUtils.isEmpty((Object)changeQuery.getEndTime())) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)EDIT_TIME).gte((Object)changeQuery.getBeginTime()));
            }
            if (!StringUtils.isEmpty((Object)changeQuery.getEndTime()) && StringUtils.isEmpty((Object)changeQuery.getBeginTime())) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)EDIT_TIME).lte((Object)changeQuery.getEndTime()));
            }
            if (!StringUtils.isEmpty((Object)changeQuery.getBeginTime()) && !StringUtils.isEmpty((Object)changeQuery.getEndTime())) {
                c.andOperator(new Criteria[]{Criteria.where((String)EDIT_TIME).gte((Object)changeQuery.getBeginTime()), Criteria.where((String)EDIT_TIME).lte((Object)changeQuery.getEndTime())});
            }
            query.addCriteria((CriteriaDefinition)c);
        }
        for (CompareInfo compareInfo : mongoCollection.find((Bson)new BasicDBObject((Map)query.getQueryObject())).sort(Sorts.descending((String[])new String[]{EDIT_TIME})).limit(count)) {
            compareInfoS.add(compareInfo);
        }
        return compareInfoS;
    }

    public List<CompareInfo> getCompareInfoListByTenant(String bucket, String source, String tenantId, int count, ChangeQuery changeQuery) {
        MongoCollection mongoCollection = super.getLoginUserDocuments(bucket, ".".concat(source));
        ArrayList<CompareInfo> compareInfoS = new ArrayList<CompareInfo>();
        BasicDBObject queryTenantId = new BasicDBObject("tenantId", (Object)tenantId);
        BasicDBObject queryEditTime = new BasicDBObject();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("$gte", changeQuery.getBeginTime());
        queryMap.put("$lte", changeQuery.getEndTime());
        if (!StringUtils.isEmpty((Object)changeQuery.getBeginTime()) || !StringUtils.isEmpty((Object)changeQuery.getEndTime())) {
            queryEditTime.put((Object)EDIT_TIME, (Object)new BasicDBObject(queryMap));
        }
        BasicDBObject queryEditUserId = new BasicDBObject();
        BasicDBObject queryEditUserName = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getEditUserId())) {
            queryEditUserId = new BasicDBObject("editUserId", (Object)Pattern.compile(Pattern.quote(changeQuery.getEditUserId())));
            queryEditUserName = new BasicDBObject("editUserName", (Object)Pattern.compile(Pattern.quote(changeQuery.getEditUserId())));
        }
        BasicDBObject queryChangedUserId = new BasicDBObject();
        BasicDBObject queryChangedUserName = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getChangedUserId())) {
            queryChangedUserId = new BasicDBObject(PRIMARY_KRY_NAME, (Object)Pattern.compile(Pattern.quote(changeQuery.getChangedUserId())));
            queryChangedUserName = new BasicDBObject("primaryName", (Object)Pattern.compile(Pattern.quote(changeQuery.getChangedUserId())));
        }
        BasicDBObject queryEditPlace = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getEditPlace())) {
            queryEditPlace.put((Object)"editPlace", (Object)changeQuery.getEditPlace());
        }
        BasicDBObject queryChangeType = new BasicDBObject();
        if (changeQuery.getActionIds() != null) {
            BasicDBList values = new BasicDBList();
            List actionIds = changeQuery.getActionIds();
            for (int i = 0; i < actionIds.size(); ++i) {
                values.add(actionIds.get(i));
            }
            BasicDBObject in = new BasicDBObject("$in", (Object)values);
            queryChangeType.put((Object)"actionId", (Object)in);
        }
        BasicDBObject query = new BasicDBObject();
        ArrayList<BasicDBObject> obj = new ArrayList<BasicDBObject>();
        if (!"*".equals(tenantId)) {
            obj.add(queryTenantId);
        }
        obj.add(queryEditTime);
        obj.add(queryEditPlace);
        obj.add(queryChangeType);
        BasicDBObject userQuery = new BasicDBObject();
        ArrayList<BasicDBObject> userQuerys = new ArrayList<BasicDBObject>();
        userQuerys.add(queryEditUserId);
        userQuerys.add(queryEditUserName);
        userQuery.put((Object)"$or", userQuerys);
        BasicDBObject changedUserQuery = new BasicDBObject();
        ArrayList<BasicDBObject> changedUserQuerys = new ArrayList<BasicDBObject>();
        changedUserQuerys.add(queryChangedUserId);
        changedUserQuerys.add(queryChangedUserName);
        changedUserQuery.put((Object)"$or", changedUserQuerys);
        obj.add(userQuery);
        obj.add(changedUserQuery);
        query.put((Object)"$and", obj);
        for (CompareInfo compareInfo : mongoCollection.find((Bson)query).sort(Sorts.descending((String[])new String[]{EDIT_TIME})).limit(count)) {
            compareInfoS.add(compareInfo);
        }
        return compareInfoS;
    }

    public Map<String, Object> getChangeLogsForMultiTenant(String bucket, String source, ChangeQuery changeQuery) {
        MongoCollection mongoCollection = super.getLoginUserDocuments(bucket, ".".concat(source));
        ArrayList<CompareInfo> compareInfoS = new ArrayList<CompareInfo>();
        BasicDBObject queryEditTime = new BasicDBObject();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("$gte", changeQuery.getBeginTime());
        queryMap.put("$lte", changeQuery.getEndTime());
        if (!StringUtils.isEmpty((Object)changeQuery.getBeginTime()) || !StringUtils.isEmpty((Object)changeQuery.getEndTime())) {
            queryEditTime.put((Object)EDIT_TIME, (Object)new BasicDBObject(queryMap));
        }
        BasicDBObject queryTenantId = new BasicDBObject();
        BasicDBObject queryTenantName = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getTenantInfo())) {
            queryTenantId = new BasicDBObject("tenantId", (Object)Pattern.compile(changeQuery.getTenantInfo()));
            queryTenantName = new BasicDBObject("tenantName", (Object)Pattern.compile(changeQuery.getTenantInfo()));
        }
        BasicDBObject queryChangedUserId = new BasicDBObject();
        BasicDBObject queryChangedUserName = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getChildTenantInfo())) {
            queryChangedUserId = new BasicDBObject(PRIMARY_KRY_NAME, (Object)Pattern.compile(changeQuery.getChildTenantInfo()));
            queryChangedUserName = new BasicDBObject("primaryName", (Object)Pattern.compile(changeQuery.getChildTenantInfo()));
        }
        BasicDBObject queryEditPlace = new BasicDBObject();
        if (!StringUtils.isEmpty((Object)changeQuery.getEditPlace())) {
            queryEditPlace.put((Object)"editPlace", (Object)changeQuery.getEditPlace());
        }
        BasicDBObject queryChangeType = new BasicDBObject();
        if (changeQuery.getActionIds() != null) {
            BasicDBList values = new BasicDBList();
            List actionIds = changeQuery.getActionIds();
            for (int i = 0; i < actionIds.size(); ++i) {
                values.add(actionIds.get(i));
            }
            BasicDBObject in = new BasicDBObject("$in", (Object)values);
            queryChangeType.put((Object)"actionId", (Object)in);
        }
        BasicDBObject query = new BasicDBObject();
        ArrayList<BasicDBObject> obj = new ArrayList<BasicDBObject>();
        obj.add(queryEditTime);
        obj.add(queryEditPlace);
        obj.add(queryChangeType);
        BasicDBObject tenantQuery = new BasicDBObject();
        ArrayList<BasicDBObject> tenantQuerys = new ArrayList<BasicDBObject>();
        tenantQuerys.add(queryTenantId);
        tenantQuerys.add(queryTenantName);
        tenantQuery.put((Object)"$or", tenantQuerys);
        BasicDBObject changedUserQuery = new BasicDBObject();
        ArrayList<BasicDBObject> changedUserQuerys = new ArrayList<BasicDBObject>();
        changedUserQuerys.add(queryChangedUserId);
        changedUserQuerys.add(queryChangedUserName);
        changedUserQuery.put((Object)"$or", changedUserQuerys);
        obj.add(tenantQuery);
        obj.add(changedUserQuery);
        query.put((Object)"$and", obj);
        for (CompareInfo compareInfo : mongoCollection.find((Bson)query).sort(Sorts.descending((String[])new String[]{EDIT_TIME})).skip((changeQuery.getPageIndex() - 1) * changeQuery.getPageSize()).limit(changeQuery.getPageSize().intValue())) {
            compareInfoS.add(compareInfo);
        }
        long totalCount = mongoCollection.countDocuments((Bson)query);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("totalCount", totalCount);
        resultMap.put("data", compareInfoS);
        return resultMap;
    }

    public PageData<CompareInfo> getCompareInfoPage(String bucket, String source, ChangeQuery changeQuery) {
        MongoCollection mongoCollection = super.getLoginUserDocuments(bucket, ".".concat(source));
        ArrayList<CompareInfo> compareInfoS = new ArrayList<CompareInfo>();
        BasicDBObject query = new BasicDBObject();
        long totalCount = mongoCollection.countDocuments((Bson)query);
        if (totalCount > 0L) {
            for (CompareInfo compareInfo : mongoCollection.find((Bson)query).sort(Sorts.descending((String[])new String[]{EDIT_TIME})).skip((changeQuery.getPageIndex() - 1) * changeQuery.getPageSize()).limit(changeQuery.getPageSize().intValue())) {
                compareInfoS.add(compareInfo);
            }
        }
        return PageData.data((long)totalCount, compareInfoS);
    }

    private ChangeInfo simplePropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        Optional<Map> logField = logFieldList.stream().filter(logFieldMap -> ((String)logFieldMap.get("fieldName")).equals(logFieldPath.getPath())).findFirst();
        logFieldPath.pop();
        if (logField.orElse(null) == null) {
            return null;
        }
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setDisplayName((String)logField.get().get("displayName"));
        changeInfo.setType("simpleProperty");
        changeInfo.setOriginValue(originValue == null ? "" : originValue.toString());
        changeInfo.setModifyValue(modifyValue == null ? "" : modifyValue.toString());
        return changeInfo;
    }

    private ChangeInfo complexPropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setType("complexProperty");
        changeInfo.setChangeInfoList(this.getModifyContent((Map)originValue, (Map)modifyValue, logFieldList, primaryKeyList, logFieldPath));
        logFieldPath.pop();
        return changeInfo;
    }

    private ChangeInfo collectionPropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        Optional<Map> primaryKeyFirst = primaryKeyList.stream().filter(primaryKeyMap -> ((String)primaryKeyMap.get("path")).equals(logFieldPath.getPath())).findFirst();
        if (primaryKeyFirst.orElse(null) == null) {
            logFieldPath.pop();
            return null;
        }
        String primaryKey = (String)primaryKeyFirst.get().get("keyName");
        String showField = (String)primaryKeyFirst.get().get("showField");
        List originChildList = (List)originValue;
        List modifyChildList = (List)modifyValue;
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setType("collectionProperty");
        ArrayList changedSet = new ArrayList();
        originChildList.forEach(map -> {
            Optional<Map> targetChildInfo = modifyChildList.stream().filter(targetChild -> targetChild.get(primaryKey).equals(map.get(primaryKey))).findFirst();
            if (targetChildInfo.orElse(null) != null) {
                ChangeInfo changeInfoChild = new ChangeInfo();
                changeInfoChild.setPrimaryKey(map.get(primaryKey).toString());
                changeInfoChild.setDisplayName(showField == null ? "" : map.get(showField).toString());
                changeInfoChild.setChangeType("update");
                List changeInfoS = this.getModifyContent(map, targetChildInfo.get(), logFieldList, primaryKeyList, logFieldPath);
                if (changeInfoS.size() > 0) {
                    changeInfoChild.setChangeInfoList(changeInfoS);
                    changedSet.add(changeInfoChild);
                }
            } else {
                ChangeInfo deleteInfo = new ChangeInfo();
                deleteInfo.setPrimaryKey(map.get(primaryKey).toString());
                deleteInfo.setDisplayName(showField == null ? "" : map.get(showField).toString());
                deleteInfo.setChangeType("delete");
                deleteInfo.setDeleteInfo(map);
                changedSet.add(deleteInfo);
            }
        });
        modifyChildList.forEach(targetChild -> {
            Optional<Map> insertList = originChildList.stream().filter(sourceChild -> sourceChild.get(primaryKey).equals(targetChild.get(primaryKey))).findFirst();
            if (insertList.orElse(null) == null) {
                ChangeInfo insertInfo = new ChangeInfo();
                insertInfo.setPrimaryKey(targetChild.get(primaryKey).toString());
                insertInfo.setDisplayName(showField == null ? "" : targetChild.get(showField).toString());
                insertInfo.setChangeType("insert");
                insertInfo.setInsertInfo(targetChild);
                changedSet.add(insertInfo);
            }
        });
        changeInfo.setChangedSet(changedSet);
        logFieldPath.pop();
        return changeInfo;
    }
}

