/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.obsolete.domain.ShareFileTarget;
import com.digiwin.dap.middleware.dmc.obsolete.service.ShareFileService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ShareFileServiceImpl
implements ShareFileService {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ShareCrudService shareCrudService;

    public String shareFileForever(String bucket, FileInfo fileInfo, ShareFileTarget target) {
        SharedFile sharedFile = new SharedFile();
        sharedFile.setUserId(UserUtils.getUserId());
        sharedFile.setUserName(UserUtils.getUserName());
        sharedFile.setFileId(fileInfo.getId().toString());
        sharedFile.setFileName(fileInfo.getFileName());
        sharedFile.setPubic(false);
        sharedFile.setExpired(false);
        sharedFile.setShareFileDate(LocalDateTime.now().format(Constants.DATETIME_FORMATTER));
        sharedFile.setUsersTarget(target.getUserIds());
        sharedFile.setOrgsTarget(target.getOrgUris());
        sharedFile.setFileIds(Collections.singletonList(sharedFile.getFileId()));
        sharedFile.setBucket(bucket);
        return this.shareCrudService.insert((UuIdEntity)sharedFile);
    }

    public String shareFileTimeLimit(String bucket, FileInfo fileInfo, int d, ShareFileTarget target) {
        SharedFile sharedFile = new SharedFile();
        sharedFile.setUserId(UserUtils.getUserId());
        sharedFile.setUserName(UserUtils.getUserName());
        sharedFile.setFileId(fileInfo.getId().toString());
        sharedFile.setFileName(fileInfo.getFileName());
        sharedFile.setPubic(false);
        sharedFile.setExpired(true);
        sharedFile.setExpireDate(LocalDateTime.now().plusDays(d).format(Constants.DATETIME_FORMATTER));
        sharedFile.setShareFileDate(LocalDateTime.now().format(Constants.DATETIME_FORMATTER));
        sharedFile.setUsersTarget(target.getUserIds());
        sharedFile.setOrgsTarget(target.getOrgUris());
        sharedFile.setFileIds(Collections.singletonList(sharedFile.getFileId()));
        sharedFile.setBucket(bucket);
        return this.shareCrudService.insert((UuIdEntity)sharedFile);
    }

    public void updateUrl(String bucket, String id, String url) {
        SharedFile sharedFile = (SharedFile)this.shareCrudService.findById(bucket, IdUtil.uuid((String)id));
        sharedFile.setUrl(url);
        this.shareCrudService.update((UuIdEntity)sharedFile);
    }

    public List<SharedFile> getSharedFilesGiveMy(List<SharedFile> sharedFiles, JwtUser jwtUser) {
        ArrayList<SharedFile> sharedFileList = new ArrayList<SharedFile>();
        for (SharedFile sharedFile : sharedFiles) {
            List userIds = sharedFile.getUsersTarget();
            List orgIds = sharedFile.getOrgsTarget();
            String shareFileUserId = sharedFile.getUserId();
            String userId = jwtUser.getIam() != false ? jwtUser.getUserId() : jwtUser.getUserId();
            if (userId.equals(shareFileUserId)) continue;
            if (userIds != null && userIds.size() > 0 || orgIds != null && orgIds.size() > 0) {
                if (userIds == null || userIds.size() <= 0) continue;
                for (String id : userIds) {
                    if (!userId.equals(id)) continue;
                    sharedFileList.add(sharedFile);
                }
                continue;
            }
            sharedFileList.add(sharedFile);
        }
        return sharedFileList;
    }

    private String getShareUrl(String bucketName, String shareFileId) {
        String userName = UserUtils.getUserId();
        String tenantId = UserUtil.getTenant();
        String url = "MyDocument".equals(bucketName) ? (tenantId == null || "default".equals(tenantId) ? String.format("%s://%s:%s/api/dmc/v1/myresources/%s/shareFiles/files/%s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), userName, shareFileId) : String.format("%s://%s:%s/api/dmc/v1/myresources/%s/%s/shareFiles/files/%s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), tenantId, userName, shareFileId)) : (StringUtils.hasText((String)this.envProperties.getDmcUri()) ? String.format("%s/api/dmc/v1/buckets/%s/shareFiles/files/%s", this.envProperties.getDmcUri(), bucketName, shareFileId) : String.format("%s://%s:%s/api/dmc/v1/buckets/%s/shareFiles/files/%s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), bucketName, shareFileId));
        return url;
    }
}

