/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.CoaUser;
import com.digiwin.dap.middleware.dmc.obsolete.entity.UserIam;
import com.digiwin.dap.middleware.dmc.obsolete.repository.UserIamRepository;
import com.digiwin.dap.middleware.dmc.obsolete.service.UserIamService;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIamServiceImpl
implements UserIamService {
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private UserIamRepository userIamRepository;

    public List<UserIam> insert(List<CoaUser> coaUsers, String tenantId, String userName, String bucketName) {
        ArrayList<UserIam> users = new ArrayList<UserIam>();
        for (CoaUser coaUser : coaUsers) {
            List iamUsers = this.userIamRepository.findByTenantIdAndUserIdAndBucketName(tenantId, coaUser.getUserId(), bucketName);
            if (iamUsers.size() > 0) {
                for (UserIam iamUser : iamUsers) {
                    if (iamUser.getUserId().equals(coaUser.getUserId())) continue;
                    this.addBucketIamUsers(tenantId, userName, bucketName, users, coaUser);
                }
                continue;
            }
            this.addBucketIamUsers(tenantId, userName, bucketName, users, coaUser);
        }
        return users;
    }

    private void addBucketIamUsers(String tenantId, String userName, String bucketName, List<UserIam> iamUsers, CoaUser user) {
        if (!user.getUserId().equals(userName)) {
            UserIam iamUser = new UserIam();
            iamUser.setBucketName(bucketName);
            iamUser.setUserId(user.getUserId());
            iamUser.setUserName(user.getUserName());
            iamUser.setTenantId(tenantId);
            this.userIamRepository.insert((ObIdEntity)iamUser);
            iamUsers.add(iamUser);
        }
    }

    public void deleteBucket(String bucketName, String tenantId) {
        this.mongoClient.getDatabase(bucketName).drop();
        this.bucketRepository.deleteByNameAndTenantId(bucketName, tenantId);
        List iamUsers = this.userIamRepository.findByTenantIdAndBucketName(tenantId, bucketName);
        for (UserIam userIam : iamUsers) {
            this.userIamRepository.deleteByTenantIdAndUserIdAndBucketName(userIam.getTenantId(), userIam.getUserId(), bucketName);
        }
    }
}

