/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileOp;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.FileEditHandler;
import com.digiwin.dap.middleware.dmc.online.FileViewHandler;
import com.digiwin.dap.middleware.dmc.service.admin.BucketConfigService;
import com.digiwin.dap.middleware.dmc.service.business.FileLogService;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileOnline {
    @Autowired
    private FileLogService fileLogService;
    @Autowired(required=false)
    private List<FileViewHandler> fileViewHandlers;
    @Autowired(required=false)
    private List<FileEditHandler> fileEditHandlers;
    @Autowired
    private BucketConfigService bucketConfigService;

    public String getViewUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        this.fileLogService.fileOpLog(FileOp.FilePreview, fileInfo);
        fileInfo.setExtension(FileUtil.getExtension((FileInfo)fileInfo));
        OnlineEnum online = this.bucketConfigService.getFileOnline(bucket, fileInfo);
        FileViewHandler viewHandler = this.getFileViewHandler(online);
        if (viewHandler != null) {
            if (viewHandler.supports(fileInfo)) {
                return viewHandler.getPreviewUrl(bucket, fileInfo, request);
            }
            FileViewHandler dmcViewHandler = this.getFileViewHandler(OnlineEnum.DMC);
            if (dmcViewHandler.supports(fileInfo)) {
                return dmcViewHandler.getPreviewUrl(bucket, fileInfo, request);
            }
            throw new BusinessException((ErrorHandler)I18nError.FILE_VIEW_NOT_SUPPORT, new Object[]{fileInfo.getExtension()});
        }
        String message = I18nError.FILE_ONLINE_SERVICE_NOT_LOAD.getMessage(new Object[]{online.name(), online.view()});
        throw new BusinessException((ErrorHandler)I18nError.FILE_VIEW_NOT_SUPPORT, new Object[]{fileInfo.getExtension()}, message);
    }

    private FileViewHandler getFileViewHandler(OnlineEnum online) {
        Optional<FileViewHandler> viewHandler = this.fileViewHandlers.stream().filter(handler -> handler.type() == online).findFirst();
        return viewHandler.orElse(null);
    }

    public String getEditUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        this.fileLogService.fileOpLog(FileOp.FileEdit, fileInfo);
        fileInfo.setExtension(FileUtil.getExtension((FileInfo)fileInfo));
        OnlineEnum online = this.bucketConfigService.getFileOnline(bucket, fileInfo);
        Optional<FileEditHandler> editHandler = this.fileEditHandlers.stream().filter(handler -> handler.type() == online).findFirst();
        if (editHandler.isPresent()) {
            if (editHandler.get().supports(fileInfo)) {
                return editHandler.get().getEditUrl(bucket, fileInfo, request);
            }
            throw new BusinessException((ErrorHandler)I18nError.FILE_EDIT_NOT_SUPPORT, new Object[]{fileInfo.getExtension()});
        }
        String message = I18nError.FILE_ONLINE_SERVICE_NOT_LOAD.getMessage(new Object[]{online.name(), online.edit()});
        throw new BusinessException((ErrorHandler)I18nError.FILE_EDIT_NOT_SUPPORT, new Object[]{fileInfo.getExtension()}, message);
    }
}

