/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.kdoc;

import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.online.base.kdoc.WPS4Util;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class KdocInterceptor
implements ClientHttpRequestInterceptor,
InitializingBean {
    @Autowired
    private EnvProperties env;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String path = request.getURI().getPath();
        if (request.getURI().getRawQuery() != null && !"".equals(request.getURI().getRawQuery())) {
            path = path + "?" + request.getURI().getRawQuery();
        }
        if (path.startsWith("/open")) {
            path = path.replace("/open", "");
        }
        Map headers = null;
        try {
            headers = WPS4Util.getSignatureHeaders((String)path, (String)HttpMethod.GET.toString(), null, (String)"application/json");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        request.getHeaders().add("Wps-Docs-Date", (String)headers.get("Wps-Docs-Date"));
        request.getHeaders().add("Wps-Docs-Authorization", (String)headers.get("Wps-Docs-Authorization"));
        return execution.execute(request, body);
    }

    public void afterPropertiesSet() throws Exception {
        WPS4Util.initAppInfo((String)this.env.getKdocAk(), (String)this.env.getKdocSk());
    }
}

