/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.kdoc;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WPS4Util {
    private static final Logger log = LoggerFactory.getLogger(WPS4Util.class);
    public static final String HTTP_HEADER_WPS_DOCS_DATE = "Wps-Docs-Date";
    public static final String HTTP_HEADER_WPS_DOCS_AUTHORIZATION = "Wps-Docs-Authorization";
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String WPS_SIGNATURE_VERSION = "WPS-4";
    public static final String[] WORD_EXT = new String[]{"doc", "dot", "wps", "wpt", "docx", "dotx", "docm", "dotm", "rtf", "txt"};
    public static final String[] EXCEL_EXT = new String[]{"xls", "xlt", "et", "xlsx", "xltx", "xlsm", "xltm", "csv"};
    public static final String[] PPT_EXT = new String[]{"ppt", "pptx", "pptm", "ppsx", "ppsm", "pps", "potx", "potm", "dpt", "dps"};
    public static final String[] PDF_EXT = new String[]{"pdf", "ofd"};
    public static final String[] X_EXT = new String[]{"jpeg", "jpg", "png", "gif", "bmp", "tif", "tiff", "svg", "psd", "tar", "zip", "7z", "gz", "rar", "md", "c", "cpp", "java", "js", "css", "lrc", "h", "asm", "s", "asp", "bat", "bas", "prg", "cmd", "xml"};
    private static String appId = "";
    private static String secretKey = "";

    public static void initAppInfo(String appId, String secretKey) {
        WPS4Util.appId = appId;
        WPS4Util.secretKey = secretKey;
    }

    public static String getFileType(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String ext = filename.substring(index + 1);
        for (String element : WORD_EXT) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)element)) continue;
            return "w";
        }
        for (String item : EXCEL_EXT) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)item)) continue;
            return "s";
        }
        for (String value : PPT_EXT) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)value)) continue;
            return "p";
        }
        for (String s : PDF_EXT) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)s)) continue;
            return "f";
        }
        for (String s : X_EXT) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)s)) continue;
            return "x";
        }
        return null;
    }

    private static String getContentSha256(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        return DigestUtils.sha256Hex((String)content);
    }

    private static String getGMTDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    private static String getWpsAuthorization(String ver, String httpMethod, String uriWithQuerystring, String contentSha256, String dateString, String contentType) throws Exception {
        String signatureStr = String.format("%s%s%s%s%s%s", ver, httpMethod, uriWithQuerystring, contentType, dateString, contentSha256);
        log.info("\u8981\u7b7e\u540d\u7684\u503c:{}", (Object)signatureStr);
        return String.format("WPS-4 %s:%s", appId, WPS4Util.HMACSHA256((String)signatureStr, (String)secretKey));
    }

    public static Map<String, String> getSignatureHeaders(String uriWithQuerystring, String httpMethod, String content, String contentType) throws Exception {
        if (uriWithQuerystring == null) {
            uriWithQuerystring = "";
        }
        if (contentType == null) {
            contentType = "application/json";
        }
        String contentSha256 = WPS4Util.getContentSha256((String)content);
        String dateString = WPS4Util.getGMTDateString((Date)new Date());
        String authorization = WPS4Util.getWpsAuthorization((String)"WPS-4", (String)httpMethod, (String)uriWithQuerystring, (String)contentSha256, (String)dateString, (String)contentType);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Wps-Docs-Authorization", authorization);
        headers.put("Content-Type", contentType);
        headers.put("Wps-Docs-Date", dateString);
        log.info("\u7b7e\u540d\u7ed3\u679c: {} -> {}", (Object)"Wps-Docs-Authorization", (Object)authorization);
        log.info("\u7b7e\u540d\u7ed3\u679c: {} -> {}", (Object)"Content-Type", (Object)contentType);
        log.info("\u7b7e\u540d\u7ed3\u679c: {} -> {}", (Object)"Wps-Docs-Date", (Object)dateString);
        return headers;
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256HMAC.init(secret_key);
        byte[] array = sha256HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }
}

