/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.kmo;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.kmo.KmoFileHandler;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.FileTransformResponse;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileTransformParam;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KmoFileHandlerImpl
implements KmoFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(KmoFileHandlerImpl.class);
    private static final String DATA_TYPE_KMO_DOC = "1";
    @Autowired
    private EnvProperties env;
    @Autowired
    private RestTemplate restTemplate;

    public String transform(String bucket, FileInfo fileInfo, KmoFileTransformParam attribute) {
        if (Objects.equals(attribute.getDataType(), DATA_TYPE_KMO_DOC) && Boolean.FALSE.equals(attribute.getForceTransform())) {
            return fileInfo.getId().toString();
        }
        String fileTransformUrl = this.env.getKmoUri() + "/restful/standard/kmo/plug/v1/document/transform";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", attribute.getUserToken());
        headers.add("digi-middleware-auth-app", attribute.getAppToken());
        headers.add("Accept-Language", attribute.getAccessLanguage());
        headers.add("digi-kai-api-key", attribute.getKaiApiKey());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dmc_id", fileInfo.getId().toString());
        param.put("bucket", bucket);
        param.put("data_type", attribute.getDataType());
        param.put("callback_url", attribute.getCallbackUrl());
        HttpEntity entity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            FileTransformResponse response = (FileTransformResponse)this.restTemplate.postForObject(fileTransformUrl, (Object)entity, FileTransformResponse.class, new Object[0]);
            if (response != null && response.getResponse() != null && response.getResponse().getData() != null && response.getResponse().getData().getDmc_id() != null) {
                return response.getResponse().getData().getDmc_id();
            }
            logger.error("\u3010{}\u3011url:{},resp:{}", new Object[]{OnlineEnum.KMO, fileTransformUrl, JsonUtils.objToJson((Object)response)});
            throw new BusinessException((ErrorHandler)I18nError.FILE_TRANS_ERROR);
        }
        catch (Exception e) {
            logger.error(String.format("\u3010%s\u3011%s", OnlineEnum.KMO, fileTransformUrl), (Throwable)e);
            throw new ThirdCallException((ErrorHandler)I18nError.FILE_TRANS_ERROR, fileTransformUrl, e);
        }
    }
}

