/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.onlyoffice;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.core.codec.URL;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.OnlineRequest;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public interface OnlyOfficeHandler {
    default public Map<String, String> commonParams(Mode mode, String bucket, FileInfo fileInfo, OnlineRequest attribute) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StrUtils.isNotEmpty((String)attribute.getUserId())) {
            params.put("iam", "true");
            params.put("userId", attribute.getUserId());
            params.put("userName", attribute.getUserName());
        } else {
            params.put("iam", UserUtil.isIam() + "");
            params.put("userId", UserUtils.getUserId());
            params.put("userName", UserUtils.getUserName());
        }
        params.put("userToken", UserUtils.getToken());
        params.put("bucket", bucket);
        params.put("fileId", fileInfo.getId().toString());
        params.put("mode", mode.name().toLowerCase());
        params.put("locale", LocaleContextHolder.getLocale().toLanguageTag());
        params.put("htmlTitle", attribute.getHtmlTitle());
        return params;
    }

    default public String joinParams(Map<String, String> params) {
        return "?params=" + URL.encode((String)AES.encrypt((String)JsonUtils.writeValue(params), (String)KeyConstant.OTHER));
    }
}

