/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.onlyoffice.history;

import com.digiwin.dap.middleware.dmc.dao.BackupCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.uuid.Backup;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.onlyoffice.history.HistoryManager;
import com.digiwin.dap.middleware.dmc.online.base.onlyoffice.manager.DocumentManagerImpl;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.serializer.Constants;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.model.common.User;
import com.onlyoffice.model.documenteditor.History;
import com.onlyoffice.model.documenteditor.HistoryData;
import com.onlyoffice.model.documenteditor.history.Version;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultHistoryManager
implements HistoryManager {
    @Autowired
    private EnvProperties env;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BackupCrudService backupCrudService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private FileStorageFactory fileStorageFactory;

    public History getHistory(String bucket, String fileId) {
        ArrayList<Version> versions = new ArrayList<Version>();
        History history = new History();
        history.setHistory(versions);
        List backups = this.backupCrudService.findByFileId(bucket, IdUtil.uuid((String)fileId));
        for (Backup backup : backups) {
            versions.add(this.get((FileInfo)backup, String.valueOf(backup.getVersion())));
        }
        Integer currentVersion = backups.stream().map(Backup::getVersion).max(Comparator.naturalOrder()).orElse(0) + 1;
        history.setCurrentVersion(currentVersion + "");
        FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, fileId);
        versions.add(this.get(fileInfo, history.getCurrentVersion()));
        return history;
    }

    private Version get(FileInfo backup, String ver) {
        Version version = new Version();
        version.setKey(DocumentManagerImpl.generateRevisionId((FileInfo)backup));
        version.setCreated(backup.getCreateDate().format(Constants.DATETIME_FORMATTER));
        version.setVersion(ver);
        User user = new User();
        String prefix = this.userRepository.existsByName(backup.getCreateById()) ? CommonCode.DMC.getCode() : CommonCode.IAM.name();
        user.setId(prefix + ":" + backup.getCreateById() + ":" + backup.getCreateByName());
        user.setName(backup.getCreateByName());
        version.setUser(user);
        return version;
    }

    public HistoryData getHistoryData(String bucket, String fileId, Integer version) {
        Backup backup = this.backupCrudService.findByFileId(bucket, IdUtil.uuid((String)fileId), version);
        if (backup == null) {
            FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, fileId);
            return this.get(bucket, fileInfo, version);
        }
        return this.get(bucket, (FileInfo)backup, version);
    }

    private HistoryData get(String bucket, FileInfo backup, Integer version) {
        HistoryData historyData = new HistoryData();
        String uri = backup instanceof Backup ? this.env.getDmcUri() + "/api/dmc/v2/file/" + bucket + "/backup/download/" + backup.getId() : this.env.getDmcUri() + "/api/dmc/v2/file/" + bucket + "/preview/" + backup.getId();
        historyData.setFileType(backup.getExtension());
        historyData.setKey(DocumentManagerImpl.generateRevisionId((FileInfo)backup));
        historyData.setUrl(uri);
        historyData.setVersion(version.toString());
        historyData.setToken(this.jwtManager.createToken((Object)historyData));
        return historyData;
    }

    public void restore(String bucket, String fileId, Integer version) {
        Backup backup = this.backupCrudService.findByFileId(bucket, IdUtil.uuid((String)fileId), version);
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, (FileInfo)backup);
        byte[] bytes = fileStorage.downloadToBytes((FileInfo)backup);
        this.fileUploadService.coverUploadFromStream(bucket, fileId, (InputStream)new ByteArrayInputStream(bytes));
    }
}

