/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.onlyoffice.service;

import com.digiwin.dap.middleware.dmc.online.domain.FileCallbackData;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.model.documenteditor.Callback;
import com.onlyoffice.service.documenteditor.callback.DefaultCallbackService;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CallbackServiceImpl
extends DefaultCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(CallbackServiceImpl.class);
    @Autowired
    private FileUploadService fileUploadService;

    public CallbackServiceImpl(JwtManager jwtManager, SettingsManager settingsManager) {
        super(jwtManager, settingsManager);
    }

    public void handlerSave(Callback callback, String bucket, String fileId) throws Exception {
        String downloadUri = callback.getUrl();
        URL url = new URL(downloadUri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try (InputStream inputStream = connection.getInputStream();){
            FileCallbackData extra = new FileCallbackData();
            String userId = (String)callback.getUsers().get(0);
            String[] userInfo = userId.split(":");
            extra.setUserId(userInfo[1]);
            extra.setUserName(userInfo[2]);
            extra.setIam(Boolean.valueOf(CommonCode.IAM.name().equals(userInfo[0])));
            extra.setBucket(bucket);
            extra.setFileId(fileId);
            extra.setSize(Long.valueOf(0L));
            UserUtil.setAuthentication((String)extra.getUserId(), (String)extra.getUserName(), (boolean)extra.getIam());
            this.fileUploadService.editUpload(bucket, extra, inputStream);
        }
        connection.disconnect();
    }

    public void handlerSaveCorrupted(Callback callback, String bucket, String fileId) throws Exception {
        logger.error("Saving error...");
        logger.error("Callback object: {}", (Object)JsonUtils.objToJson((Object)callback));
    }

    public void handlerForcesave(Callback callback, String bucket, String fileId) throws Exception {
        this.handlerSave(callback, bucket, fileId);
    }
}

