/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.base.onlyoffice.service;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.User;
import com.onlyoffice.model.documenteditor.config.Document;
import com.onlyoffice.model.documenteditor.config.EditorConfig;
import com.onlyoffice.model.documenteditor.config.document.Permissions;
import com.onlyoffice.model.documenteditor.config.document.ReferenceData;
import com.onlyoffice.model.documenteditor.config.document.Type;
import com.onlyoffice.model.documenteditor.config.editorconfig.Customization;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Customer;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Logo;
import com.onlyoffice.service.documenteditor.config.DefaultConfigService;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ConfigServiceImpl
extends DefaultConfigService {
    @Autowired
    private EnvProperties env;
    @Autowired
    private BucketRepository bucketRepository;

    public ConfigServiceImpl(DocumentManager documentManager, UrlManager urlManager, JwtManager jwtManager, SettingsManager settingsManager) {
        super(documentManager, urlManager, jwtManager, settingsManager);
    }

    public Document getDocument(String bucket, String fileId, Type type) {
        Document document = super.getDocument(bucket, fileId, type);
        ReferenceData referenceData = new ReferenceData();
        referenceData.setFileKey(fileId);
        referenceData.setInstanceId(this.env.getDmcUri());
        document.setReferenceData(referenceData);
        return document;
    }

    public EditorConfig getEditorConfig(String bucket, String fileId, Mode mode, Type type) {
        EditorConfig editorConfig = super.getEditorConfig(bucket, fileId, mode, type);
        editorConfig.setLang(LocaleContextHolder.getLocale().toLanguageTag());
        return editorConfig;
    }

    public Permissions getPermissions(String bucket, String fileId) {
        Bucket buck = this.bucketRepository.findByName(bucket);
        if (buck == null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, new Object[]{bucket});
        }
        Map yozoView = buck.getYozoView();
        boolean isCopy = "1".equals(yozoView.get("isCopy"));
        boolean isDownload = "1".equals(yozoView.get("isDownload"));
        boolean isPrint = "1".equals(yozoView.get("isPrint"));
        Permissions permissions = new Permissions();
        permissions.setChat(Boolean.valueOf(false));
        permissions.setComment(Boolean.valueOf(false));
        permissions.setCopy(Boolean.valueOf(isCopy));
        permissions.setDownload(Boolean.valueOf(isDownload));
        permissions.setEdit(Boolean.valueOf(true));
        permissions.setFillForms(Boolean.valueOf(false));
        permissions.setPrint(Boolean.valueOf(isPrint));
        permissions.setReview(Boolean.valueOf(false));
        return permissions;
    }

    public User getUser() {
        User user = new User();
        String prefix = UserUtil.isIam() ? CommonCode.IAM.name() : CommonCode.DMC.name();
        user.setId(prefix + ":" + UserUtils.getUserId() + ":" + UserUtils.getUserName());
        user.setName(UserUtils.getUserName());
        return user;
    }

    public Customization getCustomization(String bucket, String fileId) {
        Customization customization = super.getCustomization(bucket, fileId);
        customization.setHideRightMenu(Boolean.valueOf(true));
        customization.setLogo(new Logo());
        customization.setCustomer(new Customer());
        if (Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale())) {
            customization.getLogo().setImage("https://dmc.digiwincloud.com/api/dmc/v2/file/digiwincloud/preview/daccdfd0-3b1e-4f5a-bc2c-d4cb3d4b6749");
            customization.getLogo().setUrl("https://www.digiwin.com/tw");
            customization.getCustomer().setLogo("https://dmc.digiwincloud.com/api/dmc/v2/file/digiwincloud/preview/b2430490-5859-40b1-88fa-a271c4b18dcf");
            customization.getCustomer().setName("\u9f0e\u65b0\u6578\u667a");
            customization.getCustomer().setAddress("\u65b0\u5317\u5e02\u65b0\u5e97\u5340\u4e2d\u8208\u8def\u4e00\u6bb5222\u865f");
            customization.getCustomer().setPhone("02-89111688");
            customization.getCustomer().setWww("https://www.digiwin.com/tw");
        } else {
            customization.getLogo().setImage("https://dmc.digiwincloud.com.cn/api/dmc/v2/file/digiwincloud/preview/9d8e1e6f-88d3-4af6-97a7-e039b1c45f5a");
            customization.getLogo().setUrl("https://www.digiwin.com");
            customization.getCustomer().setLogo("https://dmc.digiwincloud.com.cn/api/dmc/v2/file/digiwincloud/preview/6219dabb-02a3-48d2-ad35-b9cb5cf74302");
            customization.getCustomer().setName("\u9f0e\u6377\u6570\u667a");
            customization.getCustomer().setAddress("\u4e0a\u6d77\u5e02\u9759\u5b89\u533a\u6c5f\u573a\u8def1377\u5f041\u53f7\u697c22\u5c42");
            customization.getCustomer().setPhone("400-626-5858");
            customization.getCustomer().setWww("www.digiwin.com");
        }
        return customization;
    }
}

