/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.domain.kmo;

import com.digiwin.dap.middleware.dmc.online.domain.FileViewRequest;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileTransformParam;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class KmoFileViewRequest
extends FileViewRequest
implements KmoFileTransformParam {
    private final String appToken;

    public KmoFileViewRequest(HttpServletRequest request) {
        super(request);
        this.appToken = Optional.ofNullable(request.getParameter("digi_middleware_auth_app")).orElse(request.getHeader("digi-middleware-auth-app"));
    }

    public String getKaiApiKey() {
        return Optional.ofNullable(this.getParams().get("digi_kai_api_key")).orElse("");
    }

    public String getUserToken() {
        return Optional.ofNullable(this.getParams().get("token")).orElse("");
    }

    public String getAppToken() {
        return Optional.ofNullable(this.appToken).orElse("");
    }

    public String getAccessLanguage() {
        return Optional.ofNullable(this.getParams().get("accept_language")).orElse("zh-CN");
    }

    public String getCallbackUrl() {
        return Optional.ofNullable(this.getParams().get("callback_url")).orElse("");
    }

    public String getDataType() {
        return Optional.ofNullable(this.getParams().get("data_type")).orElse("0");
    }

    public Boolean getForceTransform() {
        return false;
    }

    public String getIsPublic() {
        return Optional.ofNullable(this.getParams().get("isPublic")).orElse("");
    }

    public String getHideFavorites() {
        return Optional.ofNullable(this.getParams().get("hide_favorites")).orElse("");
    }

    public String getHideEdit() {
        return Optional.ofNullable(this.getParams().get("hide_edit")).orElse("");
    }

    public String getCustomCapacityError() {
        return Optional.ofNullable(this.getParams().get("custom_capacity_error")).orElse("");
    }

    public String getHideHome() {
        return Optional.ofNullable(this.getParams().get("hide_home")).orElse("");
    }

    public String getHideUserInfo() {
        return Optional.ofNullable(this.getParams().get("hide_user_info")).orElse("");
    }

    public String getHideHead() {
        return Optional.ofNullable(this.getParams().get("hide_head")).orElse("");
    }
}

