/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.edit;

import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.kmo.KmoFileHandler;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileEditRequest;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileTransformParam;
import com.digiwin.dap.middleware.dmc.online.edit.AbstractFileEditHandler;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.kmo.uri'))}")
public class KmoFileEditHandler
extends AbstractFileEditHandler {
    @Autowired
    private EnvProperties env;
    @Autowired
    private KmoFileHandler kmoFileHandler;

    public String getEditUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        KmoFileEditRequest attribute = new KmoFileEditRequest(request);
        String dmcId = this.kmoFileHandler.transform(bucket, fileInfo, (KmoFileTransformParam)attribute);
        return this.env.getKmoUri() + "/restful/standard/kmo/plug/v1/document/edit" + "?digi_middleware_auth_app=" + attribute.getAppToken() + "&token=" + attribute.getUserToken() + "&data_type=" + attribute.getDataType() + "&accept_language=" + attribute.getAccessLanguage() + "&dmc_id=" + dmcId + "&bucket=" + bucket + "&isPublic=" + attribute.getIsPublic() + "&hide_favorites=" + attribute.getHideFavorites() + "&hide_edit=" + attribute.getHideEdit() + "&custom_capacity_error=" + attribute.getCustomCapacityError() + "&hide_home=" + attribute.getHideHome() + "&hide_user_info=" + attribute.getHideUserInfo();
    }

    public OnlineEnum type() {
        return OnlineEnum.KMO;
    }
}

