/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.edit;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.onlyoffice.OnlyOfficeHandler;
import com.digiwin.dap.middleware.dmc.online.domain.OnlineRequest;
import com.digiwin.dap.middleware.dmc.online.domain.onlyoffice.OnlyOfficeFileEditRequest;
import com.digiwin.dap.middleware.dmc.online.edit.AbstractFileEditHandler;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.onlyoffice.uri'))}")
public class OnlyOfficeFileEditHandler
extends AbstractFileEditHandler
implements OnlyOfficeHandler {
    @Autowired
    private EnvProperties env;
    @Autowired
    private DocumentManager documentManager;

    public boolean supports(FileInfo fileInfo) {
        return this.documentManager.isEditable(fileInfo.getFileName()) || super.supports(fileInfo);
    }

    public String getEditUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        OnlyOfficeFileEditRequest attribute = new OnlyOfficeFileEditRequest(request);
        if (StrUtils.isEmpty((String)attribute.getHtmlTitle())) {
            attribute.setHtmlTitle(this.env.getHtmlTitle());
        }
        String previewUrl = this.env.getDmcUri() + "/api/dmc/3rd/onlyoffice/editor";
        Map params = this.commonParams(Mode.EDIT, bucket, fileInfo, (OnlineRequest)attribute);
        return previewUrl + this.joinParams(params);
    }

    public OnlineEnum type() {
        return OnlineEnum.ONLYOFFICE;
    }
}

