/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.edit;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.FileCallbackData;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.EditRequestBody;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.EditRequestData;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.EditResponseBody;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.YozoFileEditRequest;
import com.digiwin.dap.middleware.dmc.online.edit.AbstractFileEditHandler;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.yozo.edit-uri'))}")
public class YozoFileEditHandler
extends AbstractFileEditHandler {
    private static final Logger logger = LoggerFactory.getLogger(YozoFileEditHandler.class);
    @Autowired
    private EnvProperties env;
    @Autowired
    private RestTemplate restTemplate;

    public String getEditUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        YozoFileEditRequest attribute = new YozoFileEditRequest(request);
        EditRequestBody reqBody = new EditRequestBody();
        reqBody.setMethod(Integer.valueOf(1));
        EditRequestData reqData = new EditRequestData();
        reqData.setFilePath(String.format("%s/api/dmc/v2/file/%s/preview/%s", this.env.getDmcUri(), bucket, fileInfo.getId()));
        reqData.setUserId(attribute.isCustom() ? attribute.getUserId() : UserUtils.getUserId());
        reqData.setFileId(fileInfo.getId().toString().replace("-", ""));
        reqData.setFileName(fileInfo.getFileName());
        reqData.setUserRight(attribute.getUserRight());
        reqData.setCallbackUrl(this.env.getDmcUri() + "/api/dmc/3rd/file/edit");
        FileCallbackData extraData = new FileCallbackData();
        extraData.setBucket(bucket);
        extraData.setIam(Boolean.valueOf(UserUtil.isIam()));
        if (attribute.isCustom()) {
            extraData.setUserId(attribute.getUserId());
            extraData.setUserName(attribute.getUserName());
        } else {
            extraData.setUserId(UserUtils.getUserId());
            extraData.setUserName(UserUtils.getUserName());
        }
        extraData.setFileId(fileInfo.getId().toString());
        reqData.setExtraData(extraData);
        reqBody.setParams(reqData);
        String editUri = this.env.getYozoEditUri() + "/api.do";
        try {
            LinkedMultiValueMap resMap = new LinkedMultiValueMap();
            resMap.add((Object)"jsonParams", (Object)JsonUtils.objToJson((Object)reqBody));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)resMap, (MultiValueMap)headers);
            String resStr = (String)this.restTemplate.postForObject(editUri, (Object)httpEntity, String.class, new Object[0]);
            EditResponseBody resBody = (EditResponseBody)JsonUtils.jsonToObj((String)resStr, EditResponseBody.class);
            if (resBody != null && resBody.getErrorCode() == 0) {
                return resBody.getResult().getUrls();
            }
            throw new BusinessException((ErrorHandler)I18nError.FILE_EDIT_ERROR, resStr);
        }
        catch (HttpStatusCodeException e) {
            throw new ThirdCallException((ErrorHandler)I18nError.FILE_EDIT_ERROR, editUri, (Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error(String.format("\u3010%s\u3011%s", this.type(), editUri), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_EDIT_ERROR, e.getMessage());
        }
    }

    public OnlineEnum type() {
        return OnlineEnum.YOZO;
    }
}

