/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.view;

import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.FileViewHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractFileViewHandler
implements FileViewHandler,
InitializingBean {
    private static final String DEFAULT_EXTENSIONS_LOCATION = "META-INF/%s.properties";
    protected Map<String, String> extensions = new HashMap(128);

    public boolean supports(FileInfo fileInfo) {
        return this.extensions.containsKey(fileInfo.getExtension());
    }

    public void afterPropertiesSet() throws Exception {
        String resourceName = String.format(DEFAULT_EXTENSIONS_LOCATION, this.type().name().toLowerCase());
        Properties properties = PropertiesLoaderUtils.loadAllProperties((String)resourceName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        CollectionUtils.mergePropertiesIntoMap((Properties)properties, (Map)this.extensions);
    }
}

