/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.view;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.FileViewHandler;
import com.digiwin.dap.middleware.dmc.online.base.kdoc.KdocInterceptor;
import com.digiwin.dap.middleware.dmc.online.domain.kdoc.KdocFileInfoDto;
import com.digiwin.dap.middleware.dmc.online.domain.kdoc.KdocFileViewRequest;
import com.digiwin.dap.middleware.dmc.online.domain.kdoc.KdocPreviewVo;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.kdoc.url'))}")
public class KdocFileViewHandler
implements FileViewHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(KdocFileViewHandler.class);
    private static final String KDOC_TYPE_W = "w";
    private static final String KDOC_TYPE_S = "s";
    private static final String KDOC_TYPE_P = "p";
    private static final String KDOC_TYPE_F = "f";
    private static final String KDOC_TYPE_X = "x";
    private static final String PREVIEW_URL = "/open/api/preview/v1/files/%s/link?type=%s&_w_third_watermarkTxt=%s&_w_third_bucket=%s&_w_third_file_info_id=%s";
    @Autowired
    private EnvProperties env;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private KdocInterceptor kdocInterceptor;
    private RestTemplate restTemplate;
    private Map<String, String> kdocSup;

    private static HttpEntity<?> requestBody(MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        return new HttpEntity((MultiValueMap)headers);
    }

    public boolean supports(FileInfo fileInfo) {
        return this.kdocSup.containsKey(fileInfo.getExtension());
    }

    public String getPreviewUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        KdocFileViewRequest attribute = new KdocFileViewRequest(request);
        String kdocType = (String)this.kdocSup.get(fileInfo.getExtension());
        String url = String.format("/open/api/preview/v1/files/%s/link?type=%s&_w_third_watermarkTxt=%s&_w_third_bucket=%s&_w_third_file_info_id=%s", fileInfo.getId(), kdocType, StringUtils.hasLength((String)attribute.getWatermarkTxt()) ? attribute.getWatermarkTxt() : "", bucket, fileInfo.getId());
        ResponseEntity exchange = this.restTemplate.exchange(this.env.getKdocUri() + url, HttpMethod.GET, KdocFileViewHandler.requestBody((MediaType)MediaType.APPLICATION_JSON), KdocPreviewVo.class, new Object[0]);
        logger.info("\u3010Kdoc-preview\u3011{}", (Object)JsonUtils.objToJson((Object)exchange));
        if (exchange != null) {
            KdocPreviewVo body = (KdocPreviewVo)exchange.getBody();
            if (body != null) {
                KdocPreviewVo.Data data = body.getData();
                if (200 == body.getCode() && data != null) {
                    return data.getLink();
                }
                throw new BusinessException("\u83b7\u53d6\u91d1\u5c71\u9884\u89c8url\u51fa\u9519\uff01code=" + body.getCode());
            }
            throw new BusinessException("\u83b7\u53d6\u91d1\u5c71\u9884\u89c8url\u51fa\u9519\uff01KdocPreviewDto null");
        }
        throw new BusinessException("\u83b7\u53d6\u91d1\u5c71\u9884\u89c8url\u51fa\u9519\uff01ResponseEntity null");
    }

    public KdocFileInfoDto notifyFileInfo(String fileId, String watermarkTxt, String bucket) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        KdocFileInfoDto ret = new KdocFileInfoDto();
        KdocFileInfoDto.File file = new KdocFileInfoDto.File();
        file.setId(fileId);
        file.setName(fileInfo.getFileName());
        file.setSize(Integer.valueOf((int)fileInfo.getSize()));
        file.setCreator(fileInfo.getCreateById());
        if (fileInfo.getCreateDate() != null) {
            file.setCreateTime(Integer.valueOf(Math.abs((int)Timestamp.valueOf(fileInfo.getCreateDate()).getTime())));
        }
        file.setModifier(fileInfo.getModifyById());
        if (fileInfo.getModifyDate() != null) {
            file.setModifyTime(Integer.valueOf(Math.abs((int)Timestamp.valueOf(fileInfo.getModifyDate()).getTime())));
        }
        String previewUrl = String.format("%s/api/dmc/v2/file/%s/preview/%s?fullfilename=%s.%s", this.env.getDmcUri(), bucket, fileInfo.getId(), fileInfo.getId(), fileInfo.getExtension());
        file.setDownloadUrl(previewUrl);
        KdocFileInfoDto.File.Watermark watermark = new KdocFileInfoDto.File.Watermark();
        if (StringUtils.hasLength((String)watermarkTxt)) {
            watermark.setType(Integer.valueOf(1));
        }
        watermark.setValue(watermarkTxt);
        file.setWatermark(watermark);
        KdocFileInfoDto.User user = new KdocFileInfoDto.User();
        user.setId(fileInfo.getModifyById());
        user.setName(fileInfo.getModifyById());
        ret.setFile(file);
        ret.setUser(user);
        return ret;
    }

    public OnlineEnum type() {
        return OnlineEnum.KDOC;
    }

    public void afterPropertiesSet() throws Exception {
        this.restTemplate = new RestTemplate();
        this.restTemplate.setInterceptors(Collections.singletonList(this.kdocInterceptor));
        this.kdocSup = new LinkedHashMap();
        this.kdocSup.put("doc", "w");
        this.kdocSup.put("dot", "w");
        this.kdocSup.put("wps", "w");
        this.kdocSup.put("wpt", "w");
        this.kdocSup.put("docx", "w");
        this.kdocSup.put("dotx", "w");
        this.kdocSup.put("docm", "w");
        this.kdocSup.put("dotm", "w");
        this.kdocSup.put("rtf", "w");
        this.kdocSup.put("txt", "w");
        this.kdocSup.put("mht", "w");
        this.kdocSup.put("mhtml", "w");
        this.kdocSup.put("htm", "w");
        this.kdocSup.put("html", "w");
        this.kdocSup.put("xls", "s");
        this.kdocSup.put("xlt", "s");
        this.kdocSup.put("et", "s");
        this.kdocSup.put("xlsx", "s");
        this.kdocSup.put("xltx", "s");
        this.kdocSup.put("csv", "s");
        this.kdocSup.put("xlsm", "s");
        this.kdocSup.put("xltm", "s");
        this.kdocSup.put("ett", "s");
        this.kdocSup.put("ppt", "p");
        this.kdocSup.put("pptx", "p");
        this.kdocSup.put("pptm", "p");
        this.kdocSup.put("ppsx", "p");
        this.kdocSup.put("ppsm", "p");
        this.kdocSup.put("pps", "p");
        this.kdocSup.put("potx", "p");
        this.kdocSup.put("potm", "p");
        this.kdocSup.put("dpt", "p");
        this.kdocSup.put("dps", "p");
        this.kdocSup.put("pot", "p");
        this.kdocSup.put("pdf", "f");
        this.kdocSup.put("ofd", "f");
        this.kdocSup.put("jpeg", "x");
        this.kdocSup.put("jpg", "x");
        this.kdocSup.put("png", "x");
        this.kdocSup.put("gif", "x");
        this.kdocSup.put("bmp", "x");
        this.kdocSup.put("tif", "x");
        this.kdocSup.put("tiff", "x");
        this.kdocSup.put("svg", "x");
        this.kdocSup.put("psd", "x");
        this.kdocSup.put("tar", "x");
        this.kdocSup.put("zip", "x");
        this.kdocSup.put("7z", "x");
        this.kdocSup.put("jar", "x");
        this.kdocSup.put("rar", "x");
        this.kdocSup.put("gzip", "x");
        this.kdocSup.put("md", "x");
        this.kdocSup.put("c", "x");
        this.kdocSup.put("cpp", "x");
        this.kdocSup.put("java", "x");
        this.kdocSup.put("js", "x");
        this.kdocSup.put("css", "x");
        this.kdocSup.put("lrc", "x");
        this.kdocSup.put("h", "x");
        this.kdocSup.put("asm", "x");
        this.kdocSup.put("s", "x");
        this.kdocSup.put("asp", "x");
        this.kdocSup.put("bat", "x");
        this.kdocSup.put("bas", "x");
        this.kdocSup.put("prg", "x");
        this.kdocSup.put("cmd", "x");
        this.kdocSup.put("xml", "x");
        this.kdocSup.put("log", "x");
        this.kdocSup.put("ini", "x");
        this.kdocSup.put("inf", "x");
        this.kdocSup.put("cdr", "x");
        this.kdocSup.put("vsd", "x");
        this.kdocSup.put("vsdx", "x");
    }
}

