/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.view;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.core.codec.URL;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.kk.KkFileViewRequest;
import com.digiwin.dap.middleware.dmc.online.view.AbstractFileViewHandler;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.kk.uri'))}")
public class KkFileViewHandler
extends AbstractFileViewHandler {
    @Autowired
    private EnvProperties env;

    public String getPreviewUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        KkFileViewRequest attribute = new KkFileViewRequest(request);
        String previewUrl = String.format("%s/api/dmc/v2/file/%s/preview/%s?fullfilename=%s.%s", this.env.getDmcUri(), bucket, fileInfo.getId(), fileInfo.getId(), fileInfo.getExtension());
        StringBuilder buffer = new StringBuilder(this.env.getKkUri());
        buffer.append("/onlinePreview?url=").append(URL.encode((String)Base64.encode((String)previewUrl)));
        if (attribute.getWatermarkTxt() != null) {
            buffer.append("&watermarkTxt=").append(URL.encode((String)attribute.getWatermarkTxt()));
        }
        if (attribute.getOfficePreviewType() != null) {
            buffer.append("&officePreviewType=").append(attribute.getOfficePreviewType());
        }
        return buffer.toString();
    }

    public OnlineEnum type() {
        return OnlineEnum.KK;
    }
}

