/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.view;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.onlyoffice.OnlyOfficeHandler;
import com.digiwin.dap.middleware.dmc.online.domain.OnlineRequest;
import com.digiwin.dap.middleware.dmc.online.domain.onlyoffice.OnlyOfficeFileViewRequest;
import com.digiwin.dap.middleware.dmc.online.view.AbstractFileViewHandler;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.onlyoffice.uri'))}")
public class OnlyOfficeFileViewHandler
extends AbstractFileViewHandler
implements OnlyOfficeHandler {
    @Autowired
    private EnvProperties env;
    @Autowired
    private DocumentManager documentManager;

    public boolean supports(FileInfo fileInfo) {
        return this.documentManager.isViewable(fileInfo.getFileName());
    }

    public String getPreviewUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        OnlyOfficeFileViewRequest attribute = new OnlyOfficeFileViewRequest(request);
        if (StrUtils.isEmpty((String)attribute.getHtmlTitle())) {
            attribute.setHtmlTitle(this.env.getHtmlTitle());
        }
        String previewUrl = this.env.getDmcUri() + "/api/dmc/3rd/onlyoffice/editor";
        Map params = this.commonParams(Mode.VIEW, bucket, fileInfo, (OnlineRequest)attribute);
        params.put("watermarkTxt", attribute.getWatermarkTxt());
        return previewUrl + this.joinParams(params);
    }

    public OnlineEnum type() {
        return OnlineEnum.ONLYOFFICE;
    }
}

