/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.online.view;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.MimeType;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.FileViewRequest;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.ViewResponseBody;
import com.digiwin.dap.middleware.dmc.online.domain.yozo.YozoFileViewRequest;
import com.digiwin.dap.middleware.dmc.online.view.AbstractFileViewHandler;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.support.context.BucketContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.online.yozo.uri'))}")
public class YozoFileViewHandler
extends AbstractFileViewHandler {
    private static final Logger logger = LoggerFactory.getLogger(YozoFileViewHandler.class);
    @Autowired
    private EnvProperties env;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private FileStorageFactory fileStorageFactory;

    public String getPreviewUrl(String bucket, FileInfo fileInfo, HttpServletRequest request) {
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        byte[] bytes = fileStorage.downloadToBytes(fileInfo);
        return this.getViewUrl(fileInfo, bytes, (FileViewRequest)new YozoFileViewRequest(request));
    }

    public OnlineEnum type() {
        return OnlineEnum.YOZO;
    }

    private String getViewUrl(FileInfo fileInfo, byte[] source, FileViewRequest attribute) {
        StringBuilder uriBuilder = new StringBuilder(this.env.getYozoUri()).append("/fcscloud/composite/upload?");
        HashMap params = new HashMap();
        params.put("convertType", this.extensions.get(fileInfo.getExtension()));
        if ("xls".equals(fileInfo.getExtension()) || "xlsx".equals(fileInfo.getExtension())) {
            params.put("isShowColWidth", "0");
        }
        if (StringUtils.hasText((String)this.env.getHtmlTitle())) {
            params.put("htmlTitle", this.env.getHtmlTitle());
        }
        if (Locale.TRADITIONAL_CHINESE.equals(this.env.getLocale())) {
            params.put("isHeaderBar", "0");
        }
        Bucket bucket = BucketContextHolder.getContext();
        params.putAll(bucket.getYozoView());
        if (StringUtils.hasText((String)attribute.getWatermarkTxt())) {
            params.put("wmContent", attribute.getWatermarkTxt());
        }
        params.putAll(attribute.getParams());
        for (Map.Entry entry : params.entrySet()) {
            uriBuilder.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        logger.info(uriBuilder.toString());
        try {
            String fileName = StringUtils.hasText((String)attribute.getFileName()) ? attribute.getFileName() : fileInfo.getFileName();
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new ByteArrayResource(source)).headers(headers -> {
                headers.setContentType(MimeType.parse((String)fileInfo.getContentType()));
                headers.setContentDisposition(ContentDisposition.formData().name("file").filename(fileName).build());
            });
            builder.part("type", (Object)MimeType.parse((String)fileInfo.getContentType()));
            HttpHeaders headers2 = new HttpHeaders();
            headers2.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity request = new HttpEntity((Object)builder.build(), (MultiValueMap)headers2);
            String result = (String)this.restTemplate.postForObject(uriBuilder.toString(), (Object)request, String.class, new Object[0]);
            ViewResponseBody resBody = (ViewResponseBody)JsonUtils.readValue((String)result, ViewResponseBody.class);
            if (resBody != null && resBody.getErrorcode() == 0) {
                return resBody.getData().getViewUrl();
            }
            throw new BusinessException(String.format("\u3010%s\u3011%s", this.type(), result));
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)I18nError.FILE_VIEW_ERROR, uriBuilder.toString(), e);
        }
    }
}

