/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.base;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketUser;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.repository.base.EntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.ObjectUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseEntityRepository<T extends ObIdEntity>
implements EntityRepository<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;

    protected Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public String insert(T data) {
        if (data.getId() == null) {
            data.setId(ObjectId.get());
        }
        UserUtil.setCreateFields(data);
        return ((ObIdEntity)this.mongoTemplate.insert(data)).getId().toString();
    }

    public void deleteById(String id) {
        this.deleteById(new ObjectId(id));
    }

    public void deleteById(ObjectId id) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass());
    }

    public void update(T data) {
        UserUtil.setModifyFields(data);
        this.mongoTemplate.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)data.getId())), data);
    }

    public void replace(T data) {
        this.mongoTemplate.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)data.getId())), data);
    }

    public T findById(String id) {
        return (T)this.findById(new ObjectId(id));
    }

    public T findById(ObjectId id) {
        return (T)((ObIdEntity)this.mongoTemplate.findById((Object)id, this.getEntityClass()));
    }

    public List<T> findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    public List<T> findAll(T data) {
        return this.mongoTemplate.find(ObjectUtil.query(data), this.getEntityClass());
    }

    public PageData<T> findByPage(Page data) {
        long total;
        Page page;
        Page page2 = page = data == null ? Page.empty() : data;
        if (!UserUtil.getJwtUser().getAdmin().booleanValue()) {
            if (Bucket.class.equals((Object)this.getEntityClass())) {
                page.getFilters().put("current_Owner", UserUtils.getUserId());
            }
            if (User.class.equals((Object)this.getEntityClass())) {
                page.getFilters().put("current_Name", UserUtils.getUserId());
            }
            if (BucketUser.class.equals((Object)this.getEntityClass())) {
                page.getFilters().put("current_userId", UserUtils.getUserId());
            }
        }
        if ((total = this.mongoTemplate.count(page.query(), this.getEntityClass())) <= 0L) {
            return PageData.zero();
        }
        List list = this.mongoTemplate.find(page.queryWithSort(), this.getEntityClass());
        return PageData.data((long)total, (List)list);
    }

    public boolean existsById(ObjectId id) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass());
    }

    public void dropCollection() {
        this.mongoTemplate.dropCollection(this.getEntityClass());
    }
}

