/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.mongodb.client.result.DeleteResult;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class BucketRepositoryImpl
extends BaseEntityRepository<Bucket>
implements BucketRepository {
    public boolean existsByName(String name) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name)), this.getEntityClass());
    }

    public Bucket findByName(String name) {
        return (Bucket)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name)), this.getEntityClass());
    }

    public List<Bucket> findByNames(List<String> names) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"name").in(names)), this.getEntityClass());
    }

    public long deleteByNameAndTenantId(String name, String tenantId) {
        DeleteResult result = this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name).and("tenantId").is((Object)tenantId)), this.getEntityClass());
        return result.getDeletedCount();
    }

    public List<Bucket> findByOwner(String owner) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"owner").is((Object)owner)), this.getEntityClass());
    }

    public boolean existsByNameAndOwner(String name, String owner) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name).and("owner").is((Object)owner)), this.getEntityClass());
    }

    public boolean existsByNameInAndOwner(Collection<String> names, String owner) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"name").in(names).and("owner").is((Object)owner)), this.getEntityClass());
    }

    public List<Bucket> findByApiUrlNotNull() {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"ApiUrl").exists(true)), this.getEntityClass());
    }

    public List<Bucket> findByOwnerAndApiUrlNotNull(String owner) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"owner").is((Object)owner).and("ApiUrl").exists(true)), this.getEntityClass());
    }

    public List<Bucket> findByAppId(String appId) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId)), this.getEntityClass());
    }

    public List<Bucket> findByAppIds(List<String> appIds) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"appId").in(appIds)), this.getEntityClass());
    }

    public void calcFileSize(String name, long size, long count) {
        Update updateDefinition = new Update().inc("totalSize", (Number)size).inc("totalCount", (Number)count);
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name)), (UpdateDefinition)updateDefinition, this.getEntityClass());
    }
}

