/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.vo.ResourceGoodsUsageVO;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsPurchaseRecord;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsUseRecord;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsPurchaseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsUseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class ResourceGoodsPurchaseRecordRepositoryImpl
extends BaseEntityRepository<ResourceGoodsPurchaseRecord>
implements ResourceGoodsPurchaseRecordRepository {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGoodsPurchaseRecordRepositoryImpl.class);
    @Autowired
    private ResourceGoodsUseRecordRepository resourceGoodsUseRecordRepository;

    public ResourceGoodsPurchaseRecord findByPurchaseId(String purchaseId) {
        List resourceGoodsPurchaseRecordList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"purchaseId").is((Object)purchaseId)), this.getEntityClass());
        if (resourceGoodsPurchaseRecordList.size() > 1) {
            // empty if block
        }
        return resourceGoodsPurchaseRecordList.isEmpty() ? null : (ResourceGoodsPurchaseRecord)resourceGoodsPurchaseRecordList.get(0);
    }

    public ResourceGoodsPurchaseRecord findByProductCodeAndTenantId(String productCode, String tenantId) {
        if (!StringUtils.hasLength((String)productCode) || !StringUtils.hasLength((String)tenantId)) {
            throw new BusinessException("productCode and tenantId can't be empty");
        }
        List resourceGoodsPurchaseRecordList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"productCode").is((Object)productCode).and("tenantId").is((Object)tenantId)), this.getEntityClass());
        if (resourceGoodsPurchaseRecordList.size() > 1) {
            throw new BusinessException("\u6839\u636e");
        }
        return resourceGoodsPurchaseRecordList.isEmpty() ? null : (ResourceGoodsPurchaseRecord)resourceGoodsPurchaseRecordList.get(0);
    }

    public void updateOccupiedCapacityByProductCodeAndTenantId(String productCode, String tenantId, List<ResourceGoodsUsageVO> resourceGoodsUsageVOList) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"productCode").is((Object)productCode).and("tenantId").is((Object)tenantId));
        List resourceGoodsPurchaseRecordList = this.mongoTemplate.find(query, ResourceGoodsPurchaseRecord.class);
        if (!CollectionUtils.isEmpty((Collection)resourceGoodsPurchaseRecordList)) {
            for (ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord : resourceGoodsPurchaseRecordList) {
                long occupiedCapacity = resourceGoodsUsageVOList.stream().filter(vo -> vo.getUsageCapacity() != null).mapToLong(ResourceGoodsUsageVO::getUsageCapacity).sum();
                logger.warn("\u6388\u6743id:{},\u8ba1\u91cf\u5546\u54c1:{},\u79df\u6237id:{},\u78c1\u76d8\u7edf\u8ba1\u7528\u91cf:{},\u6388\u6743\u5df2\u7528\u7528\u91cf:{}", new Object[]{resourceGoodsPurchaseRecord.getPurchaseId(), productCode, tenantId, occupiedCapacity, resourceGoodsPurchaseRecord.getOccupiedCapacity()});
                Update update = new Update().set("occupiedCapacity", (Object)occupiedCapacity);
                Query updateQuery = new Query((CriteriaDefinition)Criteria.where((String)"purchaseId").is((Object)resourceGoodsPurchaseRecord.getPurchaseId()));
                this.mongoTemplate.updateFirst(updateQuery, (UpdateDefinition)update, ResourceGoodsPurchaseRecord.class);
                Map<String, Long> groupedByAppId = resourceGoodsUsageVOList.stream().collect(Collectors.groupingBy(ResourceGoodsUsageVO::getAppId, Collectors.summingLong(vo -> Optional.ofNullable(vo.getUsageCapacity()).orElse(0L))));
                for (Map.Entry<String, Long> entry : groupedByAppId.entrySet()) {
                    ResourceGoodsUseRecord resourceGoodsUseRecord = new ResourceGoodsUseRecord();
                    resourceGoodsUseRecord.setProductCode(resourceGoodsPurchaseRecord.getProductCode());
                    resourceGoodsUseRecord.setProductName(resourceGoodsPurchaseRecord.getProductName());
                    resourceGoodsUseRecord.setAppId(entry.getKey());
                    resourceGoodsUseRecord.setTenantId(resourceGoodsPurchaseRecord.getTenantId());
                    resourceGoodsUseRecord.setOccupiedCapacity(entry.getValue());
                    resourceGoodsUseRecord.setPurchaseId(resourceGoodsPurchaseRecord.getPurchaseId());
                    this.resourceGoodsUseRecordRepository.insert((ObIdEntity)resourceGoodsUseRecord);
                }
            }
        }
    }
}

