/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.entity.ResourceGoods;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class ResourceGoodsRepositoryImpl
extends BaseEntityRepository<ResourceGoods>
implements ResourceGoodsRepository {
    public String findProductCodeByAppId(String appId) {
        List resourceGoodsList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId)), this.getEntityClass());
        if (CollectionUtils.isEmpty((Collection)resourceGoodsList)) {
            return null;
        }
        List productCodeList = resourceGoodsList.stream().map(ResourceGoods::getProductCode).distinct().collect(Collectors.toList());
        if (productCodeList.size() > 1) {
            throw new BusinessException("\u5f53\u524d\u5e94\u7528" + appId + "\u5173\u8054\u591a\u4e2a\u8ba1\u91cf\u5546\u54c1");
        }
        return (String)productCodeList.get(0);
    }

    public List<ResourceGoods> findByCondition(String appId, String productCode) {
        Query query = new Query();
        if (appId != null && !appId.isEmpty()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        }
        if (productCode != null && !productCode.isEmpty()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"productCode").is((Object)productCode));
        }
        List resourceGoodsList = this.mongoTemplate.find(query, this.getEntityClass());
        return resourceGoodsList;
    }

    public void deleteByAppId(String appId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        this.mongoTemplate.remove(query, this.getEntityClass());
    }
}

