/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsApi;
import com.digiwin.dap.middleware.dmc.repository.StatsApiRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.QueryUtil;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class StatsApiRepositoryImpl
extends BaseEntityRepository<StatsApi>
implements StatsApiRepository {
    public PageData<StatsApi> findByPage(Page data) {
        long total;
        Page page = data == null ? Page.empty() : data;
        String beginDate = (String)page.getFilters().get("beginDate");
        String endDate = (String)page.getFilters().get("endDate");
        String appId = (String)page.getFilters().get("appId");
        String status = (String)page.getFilters().get("status");
        String path = (String)page.getFilters().get("path");
        String targetId = (String)page.getFilters().get("targetId");
        Query query = new Query();
        ArrayList<Criteria> dateCriteria = new ArrayList<Criteria>();
        if (StringUtils.hasLength((String)beginDate)) {
            LocalDate begin = LocalDate.parse(beginDate, Constants.DATE_FORMATTER);
            LocalDateTime beginDateTime = begin.atStartOfDay();
            dateCriteria.add(Criteria.where((String)"date").gte((Object)beginDateTime));
        }
        if (StringUtils.hasLength((String)endDate)) {
            LocalDate end = LocalDate.parse(endDate, Constants.DATE_FORMATTER);
            LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
            dateCriteria.add(Criteria.where((String)"date").lte((Object)endDateTime));
        }
        if (!dateCriteria.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(dateCriteria.toArray(new Criteria[0])));
        }
        if (StringUtils.hasLength((String)appId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        }
        if (StringUtils.hasLength((String)status)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)Integer.valueOf(status)));
        }
        if (StringUtils.hasLength((String)path)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"path").is((Object)path));
        }
        if (StringUtils.hasLength((String)targetId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"targetId").is((Object)targetId));
        }
        if ((total = this.mongoTemplate.count(query, StatsApi.class)) <= 0L) {
            return PageData.zero();
        }
        query.with(QueryUtil.sort((Map)page.getOrders())).skip((long)page.skip()).limit(page.limit());
        List list = this.mongoTemplate.find(query, StatsApi.class);
        return PageData.data((long)total, (List)list);
    }

    public void deleteByDate(LocalDate start) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"date").is((Object)start)), this.getEntityClass());
    }

    public String visitStats(LocalDate date) {
        this.deleteByDate(date);
        String today = date.format(DateTimeFormatter.BASIC_ISO_DATE);
        ArrayList<String> results = new ArrayList<String>();
        for (CommonCode middle : CommonCode.values()) {
            String pattern = String.format("%s:stats:sys:%s:*", middle.name().toLowerCase(), today);
            Set keys = RedisUtils.keys((String)pattern);
            keys.forEach(key -> {
                Map entries = RedisUtils.opsForHash().entries(key);
                entries.forEach((hk, hv) -> {
                    String[] parts = key.split(":");
                    int len = pattern.length() + parts[4].length();
                    String[] paths = key.substring(len).split("-");
                    StatsApi statsApi = new StatsApi();
                    statsApi.setDate(date);
                    statsApi.setAppId(parts[0]);
                    statsApi.setStatus(Integer.valueOf(parts[4]));
                    statsApi.setMethod(paths[0]);
                    statsApi.setPath(paths[1]);
                    statsApi.setType(parts[2]);
                    statsApi.setTargetId(String.valueOf(hk));
                    statsApi.setCount(Long.valueOf(Long.parseLong(String.valueOf(hv))));
                    this.insert((ObIdEntity)statsApi);
                });
                RedisUtils.expire((String)key, (long)7L, (TimeUnit)TimeUnit.DAYS);
            });
            if (keys.isEmpty()) continue;
            results.add(String.format("%s:%d", middle.name().toLowerCase(), keys.size()));
        }
        return ((Object)results).toString();
    }
}

