/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.stats.StatsFile;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsDiskDetail;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskDetailRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.QueryUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.mongodb.client.MongoClient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class StatsDiskDetailRepositoryImpl
extends BaseEntityRepository<StatsDiskDetail>
implements StatsDiskDetailRepository {
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private BucketRepository bucketRepository;

    public PageData<StatsDiskDetail> findByPage(Page data) {
        long total;
        Page page = data == null ? Page.empty() : data;
        String appId = (String)page.getFilters().get("appId");
        String queryTime = (String)page.getFilters().get("queryTime");
        Query query = new Query();
        if (StringUtils.hasLength((String)queryTime)) {
            LocalDateTime start = LocalDateTime.parse(queryTime, Constants.DATETIME_FORMATTER);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"queryTime").gte((Object)start).lt((Object)start.plusHours(1L)));
        }
        if (StringUtils.hasLength((String)appId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        }
        if ((total = this.mongoTemplate.count(query, StatsDiskDetail.class)) <= 0L) {
            return PageData.zero();
        }
        query.with(QueryUtil.sort((Map)page.getOrders())).skip((long)page.skip()).limit(page.limit());
        List list = this.mongoTemplate.find(query, StatsDiskDetail.class);
        return PageData.data((long)total, (List)list);
    }

    public void statsDiskDetail() {
        HashMap<Object, Long> bucketSizeMap = new HashMap<Object, Long>();
        for (Document database : this.mongoClient.listDatabases()) {
            bucketSizeMap.put(database.get((Object)"name", String.class), ((Double)database.get((Object)"sizeOnDisk", Double.class)).longValue());
        }
        List buckets = this.bucketRepository.findAll();
        Map<String, List<Bucket>> appBuckets = buckets.stream().filter(p -> p.getAppId() != null).collect(Collectors.groupingBy(Bucket::getAppId));
        for (Map.Entry<String, List<Bucket>> entry : appBuckets.entrySet()) {
            ArrayList<StatsTenant> bucketSizes = new ArrayList<StatsTenant>();
            for (Bucket bucket : entry.getValue()) {
                StatsTenant statsTenant = new StatsTenant();
                statsTenant.setBucket(bucket.getName());
                statsTenant.setSize(bucketSizeMap.getOrDefault(bucket.getName(), 0L).longValue());
                bucketSizes.add(statsTenant);
            }
            StatsDiskDetail statsDiskDetail = new StatsDiskDetail();
            statsDiskDetail.setAppId(entry.getKey());
            statsDiskDetail.setSize(Long.valueOf(bucketSizes.stream().mapToLong(StatsFile::getSize).sum()));
            statsDiskDetail.setQueryTime(LocalDateTime.now());
            statsDiskDetail.setBuckets(bucketSizes);
            this.insert((ObIdEntity)statsDiskDetail);
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"createDate").lt((Object)LocalDate.now().minusWeeks(1L))), this.getEntityClass());
        }
    }
}

