/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.domain.BaseVO;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsDiskBucketInfo;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsDiskResult;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsDiskTenantInfo;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsFile;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsDisk;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.QueryUtil;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.support.remote.IamService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.CountOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class StatsDistRepositoryImpl
extends BaseEntityRepository<StatsDisk>
implements StatsDiskRepository {
    @Autowired
    private IamService iamService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoStatService fileInfoStatService;
    @Autowired
    private StatsVisitRepository statsVisitRepository;

    private static void handleDate(Map<String, Object> filters, Query query) {
        String beginDateStr = filters.getOrDefault("beginDate", "").toString();
        String endDateStr = filters.getOrDefault("endDate", "").toString();
        if (!beginDateStr.isEmpty()) {
            LocalDate beginDate = LocalDate.parse(beginDateStr);
            Criteria criteria = Criteria.where((String)"date").gte((Object)beginDate);
            if (!endDateStr.isEmpty()) {
                LocalDate endDate = LocalDate.parse(endDateStr);
                criteria.lt((Object)endDate);
            }
            query.addCriteria((CriteriaDefinition)criteria);
        } else if (!endDateStr.isEmpty()) {
            LocalDate endDate = LocalDate.parse(endDateStr);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"date").lt((Object)endDate));
        }
        filters.remove("beginDate");
        filters.remove("endDate");
    }

    private static Query getQuery(Page page) {
        Query query = new Query();
        StatsDistRepositoryImpl.handleDate((Map)page.getFilters(), (Query)query);
        for (Map.Entry entry : page.getFilters().entrySet()) {
            if (ObjectUtils.isEmpty(entry.getValue())) continue;
            if ("id".equals(entry.getKey())) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if ("tenantIds".equals(entry.getKey())) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").in((Collection)((List)entry.getValue())));
                continue;
            }
            if ("appIds".equals(entry.getKey())) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").in((Collection)((List)entry.getValue())));
                continue;
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)((String)entry.getKey())).is(entry.getValue()));
        }
        return query;
    }

    public PageData<StatsDisk> findByPage(Page data) {
        Page page = data == null ? Page.empty() : data;
        Query query = StatsDistRepositoryImpl.getQuery((Page)page);
        long total = this.mongoTemplate.count(query, this.getEntityClass());
        if (total <= 0L) {
            return PageData.zero();
        }
        List list = this.mongoTemplate.find(QueryUtil.query((Query)query, (Page)page), this.getEntityClass());
        return PageData.data((long)total, (List)list);
    }

    public List<StatsDisk> findByCond(Page data) {
        Page page = data == null ? Page.empty() : data;
        Query query = StatsDistRepositoryImpl.getQuery((Page)page);
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public List<StatsDisk> findByYearMonth(String year, String month) {
        Criteria criteria = Criteria.where((String)"year").is((Object)year).and("month").is((Object)month);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria), this.getEntityClass());
    }

    public List<StatsDisk> findByCond(String year, String month, String appId, String bucket, String tenantId) {
        Criteria criteria = Criteria.where((String)"year").is((Object)year).and("month").is((Object)month).and("appId").is((Object)appId).and("bucket").is((Object)bucket);
        if (StringUtils.hasText((String)tenantId)) {
            criteria.and("tenantId").is((Object)tenantId);
        }
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria), this.getEntityClass());
    }

    public void deleteByYearMonth(String year, String month, String bucket, String tenantId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month).and("bucket").is((Object)bucket).and("tenantId").is((Object)tenantId)), this.getEntityClass());
    }

    public void diskStats(String bucketName) {
        LocalDate now = LocalDate.now();
        String[] today = now.format(Constants.DATE_FORMATTER).split("-");
        Bucket bucket = this.bucketRepository.findByName(bucketName);
        Map<String, String> appMap = this.iamService.getApp().stream().filter(p -> StrUtils.isNotEmpty((String)p.getName())).collect(Collectors.toMap(BaseVO::getId, BaseVO::getName));
        List flowResults = this.statsVisitRepository.visitStats(today[0], today[1], bucket.getName());
        Map<String, Long> flowSizeMap = flowResults.stream().collect(Collectors.toMap(StatsTenant::getTenantId, StatsFile::getSize));
        List fileResults = this.fileInfoStatService.fileStatsByTenant(bucket.getName());
        for (StatsTenant result : fileResults) {
            String tenantId = TenantUtil.getOrEmpty((String)result.getTenantId());
            this.deleteByYearMonth(today[0], today[1], result.getBucket(), tenantId);
            StatsDisk statsDisk = new StatsDisk();
            statsDisk.setDate(now);
            statsDisk.setYear(today[0]);
            statsDisk.setMonth(today[1]);
            statsDisk.setAppId(bucket.getAppId());
            statsDisk.setAppName(appMap.getOrDefault(bucket.getAppId(), bucket.getAppId()));
            statsDisk.setBucket(result.getBucket());
            statsDisk.setTenantId(tenantId);
            statsDisk.setSize(Long.valueOf(result.getSize()));
            statsDisk.setFlow(flowSizeMap.getOrDefault(tenantId, 0L));
            statsDisk.setCount(Long.valueOf(result.getCount()));
            this.insert((ObIdEntity)statsDisk);
        }
    }

    public Map diskStats4Bucket(Page page) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        String[] groupFields = new String[]{"bucket", "year", "month", "appId"};
        String[] projectionFields = new String[]{"year", "month", "appId", "bucket", "size", "flow", "tenantIdList"};
        Aggregation aggregation = this.buildAggregation(page, "bucket", groupFields, "tenantId", "tenantIdList", projectionFields, resultMap);
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "stats_disk", StatsDiskResult.class);
        List mappedResults = results.getMappedResults();
        for (StatsDiskResult result : mappedResults) {
            List tenantIds = result.getTenantIdList();
            ArrayList<StatsDiskTenantInfo> tenantInfos = new ArrayList<StatsDiskTenantInfo>();
            for (String tenantId : tenantIds) {
                StatsDisk statsDisk = (StatsDisk)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"bucket").is((Object)result.getBucket()).and("tenantId").is((Object)tenantId).and("year").is((Object)result.getYear()).and("month").is((Object)result.getMonth())), this.getEntityClass());
                StatsDiskTenantInfo tenantInfo = new StatsDiskTenantInfo(tenantId);
                if (statsDisk != null) {
                    tenantInfo.setSize(statsDisk.getSize().longValue());
                    tenantInfo.setFlow(statsDisk.getFlow().longValue());
                }
                tenantInfos.add(tenantInfo);
            }
            result.setStatsDiskTenantInfoList(tenantInfos);
        }
        resultMap.put("list", mappedResults);
        return resultMap;
    }

    public Map diskStats4Tenant(Page page) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        String[] groupFields = new String[]{"tenantId", "year", "month"};
        String[] projectionFields = new String[]{"year", "month", "tenantId", "size", "bucketList"};
        Aggregation aggregation = this.buildAggregation(page, "tenantId", groupFields, "bucket", "bucketList", projectionFields, resultMap);
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "stats_disk", StatsDiskResult.class);
        List mappedResults = results.getMappedResults();
        for (StatsDiskResult result : mappedResults) {
            List buckets = result.getBucketList();
            ArrayList<StatsDiskBucketInfo> bucketInfos = new ArrayList<StatsDiskBucketInfo>();
            for (String bucket : buckets) {
                StatsDisk statsDisk = (StatsDisk)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)result.getTenantId()).and("bucket").is((Object)bucket).and("year").is((Object)result.getYear()).and("month").is((Object)result.getMonth())), this.getEntityClass());
                StatsDiskBucketInfo bucketInfo = new StatsDiskBucketInfo(bucket);
                if (null != statsDisk) {
                    bucketInfo.setAppId(statsDisk.getAppId());
                    bucketInfo.setSize(statsDisk.getSize().longValue());
                    bucketInfo.setFlow(statsDisk.getFlow().longValue());
                }
                bucketInfos.add(bucketInfo);
            }
            result.setStatsDiskBucketInfoList(bucketInfos);
        }
        resultMap.put("list", mappedResults);
        return resultMap;
    }

    public List<StatsDisk> findByDate(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
        String month = String.format("%02d", dateTime.getMonthValue());
        String year = String.valueOf(dateTime.getYear());
        Criteria criteria = Criteria.where((String)"month").is((Object)month).and("year").is((Object)year);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria), StatsDisk.class);
    }

    public Aggregation buildAggregation(Page page, String filter, String[] groupFields, String pushField, String pushAlias, String[] projectFields, Map<String, Object> resultMap) {
        Map filters = page.getFilters();
        if (!filters.containsKey("startDate") || !filters.containsKey("endDate")) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u8d77\u6b62\u65e5\u671f");
        }
        Criteria criteria = Criteria.where((String)"createDate").gte(filters.get("startDate")).lt(filters.get("endDate"));
        if (filters.containsKey(filter) && !"".equals(filters.getOrDefault(filter, ""))) {
            String filterValue = filters.get(filter).toString();
            criteria.and(filter).is((Object)filterValue);
        }
        MatchOperation match = Aggregation.match((Criteria)criteria);
        SortOperation sort = Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"size"}));
        SkipOperation skip = Aggregation.skip((int)page.skip());
        LimitOperation limit = Aggregation.limit((long)page.limit());
        GroupOperation group = Aggregation.group((String[])groupFields).sum("size").as("size").sum("flow").as("flow").push(pushField).as(pushAlias);
        ProjectionOperation projection = Aggregation.project((String[])projectFields);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, projection, sort, skip, limit}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build());
        CountOperation count = Aggregation.count().as("total");
        AggregationResults totalResult = this.mongoTemplate.aggregate(Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, count}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build()), "stats_disk", StatsDiskResult.class);
        resultMap.put("total", totalResult.getMappedResults().isEmpty() ? 0L : ((StatsDiskResult)totalResult.getMappedResults().get(0)).getTotal());
        return aggregation;
    }
}

