/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.MongoObject;
import com.digiwin.dap.middleware.dmc.domain.enumeration.ObjectType;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketInc;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.Stats;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.support.remote.MailService;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.dmc.util.DocumentUtil;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class StatsRepositoryImpl
extends BaseEntityRepository<Stats>
implements StatsRepository {
    @Autowired
    private MailService mailService;
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoStatService fileInfoStatService;

    public void deleteByYearMonth(int year, int month) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month)), this.getEntityClass());
    }

    public Stats findByYearMonth(int year, int month) {
        return (Stats)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month)), this.getEntityClass());
    }

    public Stats findNewest() {
        return (Stats)this.mongoTemplate.findOne(new Query().with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"year"), Sort.Order.desc((String)"month")})), this.getEntityClass());
    }

    public List<BucketInc> getBucketInc(String prev, String next) {
        String[] prevs = prev.split("-");
        String[] nexts = next.split("-");
        LocalDate p = LocalDate.of(Integer.parseInt(prevs[0]), Integer.parseInt(prevs[1]), 1);
        LocalDate n = LocalDate.of(Integer.parseInt(nexts[0]), Integer.parseInt(nexts[1]), 1);
        return this.getBucketInc(p, n);
    }

    public List<BucketInc> getBucketInc(LocalDate prev, LocalDate next) {
        Stats prevStats = this.findByYearMonth(prev.getYear(), prev.getMonthValue());
        Stats nextStats = this.findByYearMonth(next.getYear(), next.getMonthValue());
        if (prevStats == null && nextStats == null) {
            return Collections.emptyList();
        }
        HashSet buckets = new HashSet();
        Map<String, Long> prevMap = null;
        Map<String, Long> nextMap = null;
        if (prevStats != null) {
            prevMap = prevStats.getBuckets().stream().collect(Collectors.toMap(BucketStats::getName, BucketStats::getTotalSize));
            Set prevs = prevStats.getBuckets().stream().map(BucketStats::getName).collect(Collectors.toSet());
            buckets.addAll(prevs);
        }
        if (nextStats != null) {
            nextMap = nextStats.getBuckets().stream().collect(Collectors.toMap(BucketStats::getName, BucketStats::getTotalSize));
            Set nexts = nextStats.getBuckets().stream().map(BucketStats::getName).collect(Collectors.toSet());
            buckets.addAll(nexts);
        }
        ArrayList<BucketInc> bucketIncs = new ArrayList<BucketInc>();
        for (String name : buckets) {
            BucketInc bucketInc = new BucketInc();
            bucketInc.setName(name);
            if (prevMap != null && prevMap.get(name) != null) {
                bucketInc.setPrev(prevMap.get(name));
                bucketInc.setPrevGb(DataUtil.byte2Gb((long)bucketInc.getPrev()));
                bucketInc.setPrevReadable(DataUtil.byteSwitch((long)bucketInc.getPrev()));
            }
            if (nextMap != null && nextMap.get(name) != null) {
                bucketInc.setNext(nextMap.get(name));
                bucketInc.setNextGb(DataUtil.byte2Gb((long)bucketInc.getNext()));
                bucketInc.setNextReadable(DataUtil.byteSwitch((long)bucketInc.getNext()));
            }
            if (bucketInc.getPrev() == null && bucketInc.getNext() != null) {
                bucketInc.setDiffSign("+");
                bucketInc.setDiff(bucketInc.getNext());
                bucketInc.setDiffReadable(DataUtil.byteSwitch((long)bucketInc.getDiff()));
            } else if (bucketInc.getPrev() != null && bucketInc.getNext() == null) {
                bucketInc.setDiffSign("-");
                bucketInc.setDiff(Long.valueOf(Math.abs(bucketInc.getPrev())));
                bucketInc.setDiffReadable(DataUtil.byteSwitch((long)bucketInc.getDiff()));
            } else if (!bucketInc.getNext().equals(bucketInc.getPrev())) {
                bucketInc.setDiffSign(bucketInc.getNext() > bucketInc.getPrev() ? "+" : "-");
                bucketInc.setDiff(Long.valueOf(Math.abs(bucketInc.getNext() - bucketInc.getPrev())));
                bucketInc.setDiffReadable(DataUtil.byteSwitch((long)bucketInc.getDiff()));
            }
            bucketIncs.add(bucketInc);
        }
        return bucketIncs.stream().sorted(Comparator.comparing(BucketInc::getNext).reversed()).collect(Collectors.toList());
    }

    public List<BucketStats> getBucketStats() {
        ArrayList<BucketStats> bucketsStats = new ArrayList<BucketStats>();
        List buckets = this.bucketRepository.findAll();
        for (Bucket bucket : buckets) {
            BucketStats bucketStats = this.fileInfoStatService.fileStatsByDeletion(bucket.getName());
            this.build(bucketStats);
            bucketsStats.add(bucketStats);
            bucket.setTotalSize(bucketStats.getTotalSize());
            bucket.setTotalCount(bucketStats.getTotalCount());
            bucket.setFileSize(bucketStats.getFileSize());
            bucket.setFileCount(bucketStats.getFileCount());
            bucket.setDeleteSize(bucketStats.getDeleteSize());
            bucket.setDeleteCount(bucketStats.getDeleteCount());
            this.bucketRepository.replace((ObIdEntity)bucket);
            if (!((double)bucket.getTotalSize() > (double)bucket.getQuotaSize() * 0.8)) continue;
            this.mailService.notifyByEmail(bucket, Integer.valueOf(1));
        }
        return bucketsStats.stream().sorted(Comparator.comparing(BucketStats::getTotalSize).reversed()).collect(Collectors.toList());
    }

    private void build(BucketStats statsResult) {
        try {
            long collections = 0L;
            long indexes = 0L;
            MongoDatabase databaseClient = this.mongoClient.getDatabase(statsResult.getName());
            for (String collection : databaseClient.listCollectionNames()) {
                ++collections;
                for (Document ignored : databaseClient.getCollection(collection).listIndexes()) {
                    ++indexes;
                }
            }
            statsResult.setCollections(collections);
            statsResult.setIndexes(indexes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Document> listIndexes(String bucket) {
        ArrayList<Document> documents = new ArrayList<Document>();
        int i = 0;
        for (Document database : this.mongoClient.listDatabases()) {
            String databaseName = database.getString((Object)"name");
            if (!ObjectUtils.isEmpty((Object)bucket) && !databaseName.equals(bucket)) continue;
            database.put("index", (Object)(++i));
            database.put("id", (Object)SnowFlake.getInstance().newId());
            database.put("type", (Object)ObjectType.database);
            documents.add(database);
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(databaseName);
            ArrayList<Document> collections = new ArrayList<Document>();
            database.append("children", collections);
            for (Document collection : mongoDatabase.listCollections()) {
                collections.add(collection);
                String collectionName = collection.getString((Object)"name");
                collection.put("id", (Object)SnowFlake.getInstance().newId());
                collection.put("bucket", (Object)databaseName);
                collection.put("type", (Object)ObjectType.collection);
                ArrayList<Document> indexes = new ArrayList<Document>();
                collection.append("children", indexes);
                for (Document index : mongoDatabase.getCollection(collectionName).listIndexes()) {
                    index.put("id", (Object)SnowFlake.getInstance().newId());
                    index.put("bucket", (Object)databaseName);
                    index.put("collection", (Object)collectionName);
                    index.put("type", (Object)ObjectType.index);
                    indexes.add(index);
                }
            }
        }
        return documents;
    }

    public void createIndex(String bucket, String collection, String filedName, Integer indexType) {
        MongoCollection mongoCollection = this.mongoClient.getDatabase(bucket).getCollection(collection);
        DocumentUtil.createIndex((MongoCollection)mongoCollection, (String)filedName, (Object)indexType);
    }

    public void drop(MongoObject mongo) {
        Bucket bucket;
        MongoDatabase database = this.mongoClient.getDatabase(mongo.getBucket());
        if (mongo.getType().equals((Object)ObjectType.index)) {
            MongoCollection mongoCollection = database.getCollection(mongo.getCollection());
            mongoCollection.dropIndex(mongo.getName());
        } else if (mongo.getType().equals((Object)ObjectType.collection) && (bucket = this.bucketRepository.findByName(mongo.getBucket())) != null && bucket.isTest()) {
            MongoCollection mongoCollection = database.getCollection(mongo.getName());
            mongoCollection.drop();
        }
    }
}

