/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.stats.StatsFile;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsVisitLog;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitLogRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.QueryUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.mongodb.client.result.DeleteResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class StatsVisitLogRepositoryImpl
extends BaseEntityRepository<StatsVisitLog>
implements StatsVisitLogRepository {
    public PageData<StatsVisitLog> findByPage(Page data) {
        Page page = data == null ? Page.empty() : data;
        Criteria criteria = this.filter(data.getFilters());
        Query query = new Query().addCriteria((CriteriaDefinition)criteria);
        long total = this.mongoTemplate.count(query, StatsVisitLog.class);
        if (total <= 0L) {
            return PageData.zero();
        }
        query.with(QueryUtil.sort((Map)page.getOrders())).skip((long)page.skip()).limit(page.limit());
        List list = this.mongoTemplate.find(query, StatsVisitLog.class);
        return PageData.data((long)total, (List)list);
    }

    private Criteria filter(Map<String, Object> filters) {
        String appId = (String)filters.get("appId");
        String bucket = (String)filters.get("bucket");
        String tenantId = (String)filters.get("tenantId");
        String fileId = (String)filters.get("fileId");
        String createBeginDate = (String)filters.get("createBeginDate");
        String createEndDate = (String)filters.get("createEndDate");
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        if (StringUtils.hasLength((String)createBeginDate)) {
            LocalDateTime start = LocalDateTime.parse(createBeginDate, Constants.DATETIME_FORMATTER);
            Criteria criteriaStart = Criteria.where((String)"createDate").gte((Object)start);
            if (StringUtils.hasLength((String)createEndDate)) {
                LocalDateTime end = LocalDateTime.parse(createEndDate, Constants.DATETIME_FORMATTER);
                criteriaStart.lt((Object)end);
            }
            criteriaList.add(criteriaStart);
        }
        if (StringUtils.hasLength((String)appId)) {
            criteriaList.add(Criteria.where((String)"appId").is((Object)appId));
        }
        if (StringUtils.hasLength((String)bucket)) {
            criteriaList.add(Criteria.where((String)"bucket").is((Object)bucket));
        }
        if (StringUtils.hasLength((String)tenantId)) {
            criteriaList.add(Criteria.where((String)"tenantId").is((Object)tenantId));
        }
        if (StringUtils.hasLength((String)fileId)) {
            criteriaList.add(Criteria.where((String)"fileId").is((Object)fileId));
        }
        return criteriaList.isEmpty() ? new Criteria() : new Criteria().andOperator(criteriaList);
    }

    public long fileSizeStats(Map<String, Object> filters) {
        Criteria criteria = this.filter(filters);
        List statsTenants = this.fileVisitStats(criteria);
        return statsTenants.stream().map(StatsFile::getSize).reduce(0L, Long::sum);
    }

    public List<StatsTenant> fileVisitStats(Criteria criteria) {
        MatchOperation match = Aggregation.match((Criteria)criteria);
        GroupOperation group = Aggregation.group((String[])new String[]{"bucket", "tenantId"}).sum("size").as("size");
        ProjectionOperation projection = Aggregation.project((String[])new String[]{"bucket", "tenantId", "size"});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, projection}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build());
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "stats_visit_log", StatsTenant.class);
        return results.getMappedResults();
    }

    public long deleteByCreateDate(LocalDate start) {
        DeleteResult deleteResult = this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"createDate").lt((Object)start)), this.getEntityClass());
        return deleteResult.getDeletedCount();
    }
}

