/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsVisit;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitLogRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class StatsVisitRepositoryImpl
extends BaseEntityRepository<StatsVisit>
implements StatsVisitRepository {
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private StatsVisitLogRepository statsVisitLogRepository;

    public StatsVisit findByYearMonth(String year, String month, String day, String bucket, String tenantId) {
        return (StatsVisit)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month).and("day").is((Object)day).and("bucket").is((Object)bucket).and("tenantId").is((Object)tenantId)), this.getEntityClass());
    }

    public void deleteByYearMonth(String year, String month, String day, String bucket, String tenantId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month).and("day").is((Object)day).and("bucket").is((Object)bucket).and("tenantId").is((Object)tenantId)), this.getEntityClass());
    }

    public List<StatsTenant> visitStats(String year, String month, String bucket) {
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"year").is((Object)year).and("month").is((Object)month).and("bucket").is((Object)bucket));
        GroupOperation group = Aggregation.group((String[])new String[]{"bucket", "tenantId"}).sum("size").as("size").count().as("count");
        ProjectionOperation projection = Aggregation.project((String[])new String[]{"bucket", "tenantId", "size", "count"});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, projection}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build());
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "stats_visit", StatsTenant.class);
        return results.getMappedResults();
    }

    public long visitStats(LocalDate date) {
        String[] today = date.format(Constants.DATE_FORMATTER).split("-");
        LocalDate tomorrow = date.plusDays(1L);
        List buckets = this.bucketRepository.findAll();
        Map<String, String> bucketMap = buckets.stream().filter(o -> StringUtils.hasLength((String)o.getAppId())).collect(Collectors.toMap(Bucket::getName, Bucket::getAppId));
        Criteria criteria = Criteria.where((String)"createDate").gte((Object)date).lt((Object)tomorrow);
        List results = this.statsVisitLogRepository.fileVisitStats(criteria);
        for (StatsTenant result : results) {
            this.deleteByYearMonth(today[0], today[1], today[2], result.getBucket(), result.getTenantId());
            StatsVisit statsVisit = new StatsVisit();
            statsVisit.setDate(date);
            statsVisit.setYear(today[0]);
            statsVisit.setMonth(today[1]);
            statsVisit.setDay(today[2]);
            statsVisit.setAppId(bucketMap.get(result.getBucket()));
            statsVisit.setBucket(result.getBucket());
            statsVisit.setTenantId(result.getTenantId());
            statsVisit.setSize(Long.valueOf(result.getSize()));
            this.insert((ObIdEntity)statsVisit);
        }
        return results.size();
    }
}

