/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.repository.impl;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.objectid.TaskLog;
import com.digiwin.dap.middleware.dmc.repository.TaskLogRepository;
import com.digiwin.dap.middleware.dmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.dmc.repository.base.QueryUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class TaskLogRepositoryImpl
extends BaseEntityRepository<TaskLog>
implements TaskLogRepository {
    public PageData<TaskLog> findByPage(Page data) {
        long total;
        Page page = data == null ? Page.empty() : data;
        String taskCode = (String)page.getFilters().get("taskCode");
        String triggerTime = (String)page.getFilters().get("triggerTime");
        Query query = new Query();
        if (StringUtils.hasLength((String)triggerTime)) {
            LocalDateTime start = LocalDateTime.parse(triggerTime, Constants.DATETIME_FORMATTER);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"triggerTime").gte((Object)start).lt((Object)start.plusHours(1L)));
        }
        if (StringUtils.hasLength((String)taskCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"taskCode").is((Object)taskCode));
        }
        if ((total = this.mongoTemplate.count(query, TaskLog.class)) <= 0L) {
            return PageData.zero();
        }
        query.with(QueryUtil.sort((Map)page.getOrders())).skip((long)page.skip()).limit(page.limit());
        List list = this.mongoTemplate.find(query, TaskLog.class);
        return PageData.data((long)total, (List)list);
    }
}

