/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service;

import com.digiwin.DWModerator;
import com.digiwin.DWModeratorBuilder;
import com.digiwin.config.DWImageModeratorOption;
import com.digiwin.constant.Cloud;
import com.digiwin.constant.ImageMime;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.ContentModerator;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.util.SpringApplicationContextUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dto.DWImageModeratorResult;
import com.digiwin.dto.DWImageModeratorResultDetail;
import com.digiwin.impl.hauwei.DWHuaweiModerator;
import com.digiwin.model.azure.ImageInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@DependsOn(value={"springApplicationContextUtil"})
public class ContentModerator
implements InitializingBean {
    public static final String DOWNLOAD_URL_TEMPLATE = "%s/api/dmc/v2/file/%s/preview/%s";
    public static final String AREA_TW = "TW";
    public static final String SUGGESTION_PASS = "pass";
    public static final String SUGGESTION_BLOCK = "block";
    public static final String SUGGESTION_REVIEW = "review";
    public static final double SIZE_LIMIT = 7.5;
    private static final Logger logger = LoggerFactory.getLogger(ContentModerator.class);
    private static final List<String> EXTENSION_LIST = Arrays.asList("gif", "jpeg", "png", "bmp");
    private static final Map<String, ImageMime> EXTENSION_MIME_MAPPING = new LinkedHashMap();
    private static LMCClient lmcClient;
    private static FileNodeService fileNodeService;
    private static EnvProperties envProperties;
    private static FileStorageFactory fileStorageFactory;

    private static DWModerator newDWModerator() {
        try {
            Cloud cloud = "TW".equalsIgnoreCase(envProperties.getCountry()) ? Cloud.AZURE : Cloud.HUAWEI;
            return DWModeratorBuilder.create().setCloud(cloud).setLmcClient(lmcClient).setAppId(envProperties.getAppName().toUpperCase()).build();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.MODERATOR_ERROR, e.getMessage());
        }
    }

    public static void processSync(String bucket, FileInfo fileInfo, boolean needModerator) {
        try {
            if (fileInfo != null) {
                ContentModerator.processAsync((String)bucket, (FileInfo)fileInfo, (boolean)needModerator).get();
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (ExecutionException e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                if (e.getCause() instanceof BusinessException) {
                    throw (BusinessException)e.getCause();
                }
                msg = e.getCause().getMessage();
            }
            throw new BusinessException((ErrorHandler)I18nError.MODERATOR_ERROR, msg);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.MODERATOR_ERROR, e.getMessage());
        }
    }

    private static CompletableFuture<String> processAsync(String bucket, FileInfo fileInfo, boolean needModerator) {
        ImageInfo imageinfo;
        if (!needModerator && !fileInfo.isNeedModerator()) {
            logger.debug("\u8df3\u8fc7\u5ba1\u6838\uff1aheader={}\uff0cfieldAttr\uff1a{}", (Object)needModerator, (Object)fileInfo.isNeedModerator());
            return CompletableFuture.completedFuture("no need");
        }
        FileExistCheckParam fileExistCheckParam = new FileExistCheckParam(bucket, fileInfo.getId().toString(), fileInfo);
        CompletableFuture fileExistCHeck = ContentModerator.fileExistCheck((FileExistCheckParam)fileExistCheckParam);
        if (fileExistCHeck != null) {
            return fileExistCHeck;
        }
        fileInfo = fileExistCheckParam.getFileInfo();
        String extension = fileInfo.getExtension();
        if (!EXTENSION_LIST.contains(extension)) {
            logger.debug("\u6587\u4ef6\u7c7b\u578b\u4e0d\u6ee1\u8db3\u5185\u5bb9\u5ba1\u6838\u9650\u5236\uff1a{}", (Object)extension);
            return CompletableFuture.completedFuture("file extension not supported");
        }
        double size = fileInfo.getSize();
        double sizeMb = size / 1048576.0;
        if (sizeMb > 7.5) {
            logger.debug("\u6587\u4ef6\u8d85\u8fc7\u5185\u5bb9\u5ba1\u6838\u5927\u5c0f\u9650\u5236\uff1a{}mb", (Object)sizeMb);
            return CompletableFuture.completedFuture("file size overceed");
        }
        DWModerator dwModerator = ContentModerator.newDWModerator();
        CompletableFuture extractImageInfoFuture = ContentModerator.extractImageInfo((String)bucket, (FileInfo)fileInfo, (String)extension, (DWModerator)dwModerator, (ImageInfo)(imageinfo = new ImageInfo()));
        if (extractImageInfoFuture != null) {
            return extractImageInfoFuture;
        }
        try {
            DWImageModeratorResult result = dwModerator.imageContentModerate(new DWImageModeratorOption(), imageinfo);
            logger.info("\u3010DWImageModeratorResult\u3011{}", (Object)JsonUtils.objToJson((Object)result));
            boolean success = result.getSuccess();
            DWImageModeratorResultDetail resultDetail = result.getResultDetail();
            if (success && resultDetail != null) {
                if ("pass".equals(resultDetail.getSuggestion())) {
                    return CompletableFuture.completedFuture("passed");
                }
                if ("block".equals(resultDetail.getSuggestion())) {
                    return CompletableFuture.completedFuture("block");
                }
                if ("review".equals(resultDetail.getSuggestion())) {
                    return CompletableFuture.completedFuture("review");
                }
                throw new BusinessException((ErrorHandler)I18nError.MODERATOR_ERROR, "\u672a\u77e5\u7684\u5ba1\u6838\u7ed3\u679c\u7c7b\u578b");
            }
            return CompletableFuture.completedFuture("fail");
        }
        catch (Exception e) {
            logger.error(String.format("\u3010imageContentModerate\u3011imageinfo=%s", JsonUtils.objToJson((Object)imageinfo)), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.MODERATOR_ERROR, e.getMessage());
        }
    }

    private static CompletableFuture<String> fileExistCheck(FileExistCheckParam fileExistCheckParam) {
        if (fileExistCheckParam.getFileInfo() == null) {
            try {
                fileExistCheckParam.setFileInfo(fileNodeService.findOne(fileExistCheckParam.getBucket(), fileExistCheckParam.getFileId()));
            }
            catch (Exception e) {
                logger.warn("\u6587\u4ef6\u67e5\u627e\u5f02\u5e38\uff1abucket={}\uff1bfileId={}", (Object)fileExistCheckParam.getBucket(), (Object)fileExistCheckParam.getFileId());
                return CompletableFuture.completedFuture("file find error");
            }
        }
        if (fileExistCheckParam.getFileInfo() == null) {
            logger.warn("\u6587\u4ef6\u672a\u627e\u5230\uff1abucket={}\uff1bfileId={}", (Object)fileExistCheckParam.getBucket(), (Object)fileExistCheckParam.getFileId());
            return CompletableFuture.completedFuture("file not found");
        }
        return null;
    }

    private static CompletableFuture<String> extractImageInfo(String bucket, FileInfo fileInfo, String extension, DWModerator dwModerator, ImageInfo imageinfo) {
        String url = String.format("%s/api/dmc/v2/file/%s/preview/%s", envProperties.getDmcUri(), bucket, fileInfo.getId());
        if (dwModerator instanceof DWHuaweiModerator) {
            imageinfo.setImgUrl(url);
            imageinfo.setImgMime(ImageMime.URL);
        } else {
            imageinfo.setImgMime((ImageMime)EXTENSION_MIME_MAPPING.get(extension));
            try {
                FileStorage fileStorage = fileStorageFactory.getFileStorage(bucket, fileInfo);
                byte[] bytes = fileStorage.downloadToBytes(fileInfo);
                imageinfo.setImgStream((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (Exception e) {
                logger.warn(String.format("\u8f93\u5165\u6d41\u83b7\u53d6\u5931\u8d25\uff1a%s", url), (Throwable)e);
                return CompletableFuture.completedFuture("input stream access failed");
            }
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        lmcClient = (LMCClient)SpringApplicationContextUtil.getBean((String)"lmcClient", LMCClient.class);
        envProperties = (EnvProperties)SpringApplicationContextUtil.getBean(EnvProperties.class);
        fileNodeService = (FileNodeService)SpringApplicationContextUtil.getBean(FileNodeService.class);
        fileStorageFactory = (FileStorageFactory)SpringApplicationContextUtil.getBean(FileStorageFactory.class);
        EXTENSION_MIME_MAPPING.put("gif", ImageMime.GIF);
        EXTENSION_MIME_MAPPING.put("jpeg", ImageMime.JPEG);
        EXTENSION_MIME_MAPPING.put("png", ImageMime.PNG);
        EXTENSION_MIME_MAPPING.put("bmp", ImageMime.BMP);
    }
}

