/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.admin.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketConfig;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketConfigRepository;
import com.digiwin.dap.middleware.dmc.service.admin.BucketConfigService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BucketConfigServiceImpl
implements BucketConfigService {
    @Autowired
    private EnvProperties env;
    @Autowired
    private BucketConfigRepository bucketConfigRepository;

    public StorageEnum getStorage(String bucket, String tenantId) {
        BucketConfig bucketTenantConfig = this.bucketConfigRepository.findByBucketAndTenantId(bucket, tenantId);
        if (bucketTenantConfig != null) {
            return bucketTenantConfig.getStorage();
        }
        BucketConfig tenantConfig = this.bucketConfigRepository.findByTenantId(tenantId);
        if (tenantConfig != null) {
            return tenantConfig.getStorage();
        }
        BucketConfig bucketConfig = this.bucketConfigRepository.findByBucket(bucket);
        if (bucketConfig != null) {
            return bucketConfig.getStorage();
        }
        return null;
    }

    public StorageEnum getFileStorage(String bucket, String tenantId) {
        StorageEnum config = this.getStorage(bucket, tenantId);
        if (config != null) {
            return config;
        }
        if (this.env.getStorage() != null) {
            return this.env.getStorage();
        }
        return StorageEnum.MongoDB;
    }

    public String getBackUri(String bucket, String tenantId) {
        BucketConfig config = this.bucketConfigRepository.findByBucketAndTenantId(bucket, tenantId);
        if (config == null) {
            config = this.bucketConfigRepository.findByTenantId(tenantId);
        }
        if (config == null) {
            config = this.bucketConfigRepository.findByBucket(bucket);
        }
        if (config == null || ObjectUtils.isEmpty((Object)config.getBackUri())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_STORAGE_URI_NONE, new Object[]{tenantId});
        }
        return config.getBackUri();
    }

    public OnlineEnum getOnline(String bucket, String tenantId) {
        BucketConfig bucketTenantConfig = this.bucketConfigRepository.findByBucketAndTenantId(bucket, tenantId);
        if (bucketTenantConfig != null) {
            return bucketTenantConfig.getOnline();
        }
        BucketConfig tenantConfig = this.bucketConfigRepository.findByTenantId(tenantId);
        if (tenantConfig != null) {
            return tenantConfig.getOnline();
        }
        BucketConfig bucketConfig = this.bucketConfigRepository.findByBucket(bucket);
        if (bucketConfig != null) {
            return bucketConfig.getOnline();
        }
        return null;
    }

    public OnlineEnum getFileOnline(String bucket, FileInfo fileInfo) {
        if (fileInfo.getOnline() != null) {
            return fileInfo.getOnline();
        }
        OnlineEnum online = this.getOnline(bucket, fileInfo.getTenantId());
        if (online != null) {
            return online;
        }
        if (this.env.getOnline() != null) {
            return this.env.getOnline();
        }
        return OnlineEnum.DMC;
    }
}

