/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.admin.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsPurchaseRecord;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsPurchaseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsRepository;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.support.context.UploadContext;
import com.digiwin.dap.middleware.dmc.support.context.UploadContextHolder;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BucketServiceImpl
implements BucketService {
    private static final Logger logger = LoggerFactory.getLogger(BucketServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private ResourceGoodsRepository resourceGoodsRepository;
    @Autowired
    private ResourceGoodsPurchaseRecordRepository resourceGoodsPurchaseRecordRepository;

    public void tenantCheck(String bucketName, FileInfo fileInfo) {
        Bucket bucket = this.bucketRepository.findByName(bucketName);
        if (bucket != null && bucket.isCheck()) {
            if (!"default".equals(UserUtils.getTenantId())) {
                return;
            }
            if (fileInfo != null && StringUtils.hasLength((String)fileInfo.getTenantId())) {
                return;
            }
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_TENANT_CHECK);
        }
    }

    public void tenantCheck(String bucketName, List<FileInfo> fileInfos, long fileCount) {
        Bucket bucket = this.bucketRepository.findByName(bucketName);
        if (bucket != null && bucket.isCheck()) {
            long matchCount;
            if (!"default".equals(UserUtils.getTenantId())) {
                return;
            }
            if (fileInfos != null && (matchCount = fileInfos.stream().filter(fileInfo -> StringUtils.hasLength((String)fileInfo.getTenantId())).count()) == fileCount) {
                return;
            }
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_TENANT_CHECK);
        }
    }

    public void dealBucketSize(String bucketName, long size, int count) {
        Bucket bucket = this.bucketRepository.findByName(bucketName);
        if (bucket == null || bucket.getQuotaSize() == 0L) {
            return;
        }
        this.bucketRepository.calcFileSize(bucketName, size, (long)count);
    }

    public void checkBucketLimit(String bucketName, String tenantId, long fileSize) {
        if (!StringUtils.hasLength((String)bucketName) || !StringUtils.hasLength((String)tenantId)) {
            logger.warn("\u4e0a\u4f20\u5bb9\u91cf\u6821\u9a8c\u53c2\u6570\u5f02\u5e38,\u5b58\u50a8\u6876\u6216\u8005\u79df\u6237\u4e3a\u7a7a!");
            return;
        }
        Bucket bucket = this.bucketRepository.findByName(bucketName);
        if (bucket == null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, new Object[]{bucketName});
        }
        String appId = bucket.getAppId();
        if (!StringUtils.hasLength((String)appId)) {
            logger.warn("\u4e0a\u4f20\u5bb9\u91cf\u6821\u9a8c\u53c2\u6570\u5f02\u5e38,\u5b58\u50a8\u6876\u672a\u7ed1\u5b9a\u5e94\u7528!");
            return;
        }
        String resourceGoods = this.resourceGoodsRepository.findProductCodeByAppId(appId);
        if (Objects.isNull(resourceGoods)) {
            logger.warn("\u5f53\u524d\u5e94\u7528{}\u672a\u7ed1\u5b9a\u8ba1\u91cf\u5546\u54c1!", (Object)appId);
            return;
        }
        ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord = this.resourceGoodsPurchaseRecordRepository.findByProductCodeAndTenantId(resourceGoods, tenantId);
        if (Objects.isNull(resourceGoodsPurchaseRecord)) {
            logger.warn("\u6839\u636e\u5e94\u7528id({})\u548c\u79df\u6237id({})\u672a\u67e5\u8be2\u5230\u6388\u6743\u8bb0\u5f55,\u8ba1\u91cf\u5546\u54c1:{}!", new Object[]{appId, tenantId, resourceGoods});
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_SIZE_LIMIT, new Object[]{0, 0});
        }
        long totalUsageCapacity = Long.parseLong(resourceGoodsPurchaseRecord.getTotalUsageCapacity());
        long occupiedCapacity = Long.parseLong(resourceGoodsPurchaseRecord.getOccupiedCapacity());
        if (occupiedCapacity + fileSize > totalUsageCapacity) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_SIZE_LIMIT, new Object[]{DataUtil.byteSwitch((long)Long.parseLong(resourceGoodsPurchaseRecord.getTotalUsageCapacity())), DataUtil.byteSwitch((long)Long.parseLong(resourceGoodsPurchaseRecord.getOccupiedCapacity()))});
        }
        logger.info("\u79df\u6237{}\u4e0b\u5e94\u7528{}\u4f7f\u7528{}\u5b57\u8282\u5b58\u50a8!", new Object[]{tenantId, appId, fileSize});
        UploadContext uploadContext = new UploadContext(bucketName, Long.valueOf(fileSize), appId, resourceGoodsPurchaseRecord);
        UploadContextHolder.setContext((UploadContext)uploadContext);
    }
}

