/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.admin.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.admin.ParamCheckService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.MongoNamespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ParamCheckServiceImpl
implements ParamCheckService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BucketRepository bucketRepository;

    public void newUser(User user) {
        if (ObjectUtils.isEmpty((Object)user.getName())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NAME_NONE);
        }
        if (user.getName().contains(".")) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NAME_CHECK_FAIL);
        }
        if (ObjectUtils.isEmpty((Object)user.getPwdHash())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_NONE);
        }
        if (this.userRepository.existsByName(user.getName())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EXISTS, new Object[]{user.getName()});
        }
    }

    public void newBucket(Bucket bucket) {
        MongoNamespace.checkDatabaseNameValidity((String)bucket.getName());
        boolean exists = this.bucketRepository.existsByName(bucket.getName());
        if (exists) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_EXISTS, new Object[]{bucket.getName()});
        }
        if (ObjectUtils.isEmpty((Object)bucket.getOwner())) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_OWNER_NONE, new Object[]{bucket.getName()});
        }
        bucket.flushKey();
    }
}

