/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.I18nCode;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FidType;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.support.auth.domain.AuthHelper;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuth;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtGrantedAuthority;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FidCheckServiceImpl
implements FidCheckService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    private static boolean isSelf(String loginTenantId, String fileTenantId) {
        if (ObjectUtils.isEmpty((Object)loginTenantId) || ObjectUtils.isEmpty((Object)fileTenantId)) {
            return true;
        }
        if ("default".equals(loginTenantId) || "default".equals(fileTenantId)) {
            return true;
        }
        return Objects.equals(loginTenantId, fileTenantId);
    }

    private static boolean roleCheck(RoleAuthorize role, boolean isOwner, boolean isAdmin) {
        if (role.admin()) {
            if (role.owner()) {
                return isOwner || isAdmin;
            }
            return isAdmin;
        }
        if (role.owner()) {
            return isOwner;
        }
        return false;
    }

    public void bucketAccess(String bucket, RoleAuthorize role, Object[] values) {
        bucket = TenantUtil.getBucketNameAuth((String)bucket);
        JwtUser user = UserUtil.getJwtUser();
        boolean isAdmin = user.getAdmin();
        boolean isOwner = user.getBuckets().contains(bucket);
        if (FidCheckServiceImpl.roleCheck((RoleAuthorize)role, (boolean)isOwner, (boolean)isAdmin)) {
            return;
        }
        if (role.order() > 0) {
            String targetId;
            if (role.order() > 20) {
                targetId = ((DirInfo)values[role.order() - 20]).getParentId().toString();
                this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u4f7f\u7528DriveToken\u521b\u5efa\u76ee\u5f55", bucket + "," + targetId);
            } else if (role.order() > 10) {
                targetId = ((FileInfo)values[role.order() - 10]).getDirectoryId();
                this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u4f7f\u7528DriveToken\u4e0a\u4f20\u6587\u4ef6", bucket + "," + targetId);
            } else {
                targetId = (String)values[role.order()];
            }
            DriveAuth driveAuth = DriveAuth.driveAuth((String)bucket, (ActionEnum)role.action(), (FileTypeEnum)role.type(), (String)targetId);
            for (JwtGrantedAuthority authority : user.getAuthorities()) {
                boolean result = AuthHelper.authContains((DriveAuth)authority.getDriveAuth(), (DriveAuth)driveAuth);
                if (!result) continue;
                return;
            }
        }
        throw new BusinessException((ErrorHandler)I18nError.BUCKET_ACCESS_DENY, new Object[]{UserUtils.getUserId(), bucket});
    }

    public void canOperateId(FidType type, String bucket, String id) {
        if (type == FidType.File) {
            String fileTenantId;
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, id);
            if (fileInfo == null) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{id});
            }
            String loginTenantId = UserUtils.getTenantId();
            if (FidCheckServiceImpl.isSelf((String)loginTenantId, (String)(fileTenantId = fileInfo.getTenantId()))) {
                return;
            }
            throw new BusinessException((ErrorHandler)I18nError.FILE_ACCESS_TENANT_DENY, new Object[]{loginTenantId, id});
        }
    }

    public void canOperateFileId(String bucket, List<String> fileIds) {
        if (fileIds.size() == 1) {
            this.canOperateId(FidType.File, bucket, fileIds.get(0));
        } else if (fileIds.size() > 1) {
            List ids = fileIds.stream().map(UUID::fromString).collect(Collectors.toList());
            this.canOperateId(FidType.File, bucket, ids);
        }
    }

    public void canOperateId(FidType type, String bucket, List<UUID> ids) {
        if (type == FidType.File) {
            List validIds = this.fileNodeService.findByIds(bucket, ids);
            ids.removeAll(validIds);
            if (ids.isEmpty()) {
                return;
            }
            throw new BusinessException((ErrorHandler)I18nError.FILE_ACCESS_TENANT_DENY, new Object[]{UserUtils.getTenantId(), ids});
        }
    }

    public void newDirCheck(String bucket, DirInfo dirInfo) {
        if (!StringUtils.hasText((String)dirInfo.getName())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NAME_NONE);
        }
        dirInfo.setParentId(IdUtil.getDirId((UUID)dirInfo.getParentId()));
        if (dirInfo.getDisplayName() == null) {
            dirInfo.setDisplayName(dirInfo.getName());
        }
        if (dirInfo.getId() != null && this.directoryNodeService.existsById(bucket, dirInfo.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_EXISTS, new Object[]{dirInfo.getId()});
        }
        if (!this.directoryNodeService.existsById(bucket, dirInfo.getParentId())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_PARENT_NONE, new Object[]{dirInfo.getParentId()});
        }
        if (this.directoryNodeService.existsByName(bucket, dirInfo.getParentId(), dirInfo.getName())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_EXISTS, new Object[]{dirInfo.getName()});
        }
    }

    public void modDirCheck(String bucket, DirInfo dirInfo, UUID parentId, String newName) {
        DirInfo newDirInfo = this.directoryNodeService.findByName(bucket, parentId, newName);
        if (newDirInfo != null && !Objects.equals(dirInfo.getId(), newDirInfo.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_EXISTS, new Object[]{newName});
        }
    }

    public void fillAndCheck(String bucket, FileInfo fileInfo) {
        if (fileInfo == null || ObjectUtils.isEmpty((Object)fileInfo.getFileName())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NAME_NONE);
        }
        if (fileInfo.getId() != null && this.fileNodeService.existsById(bucket, fileInfo.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_EXISTS, new Object[]{fileInfo.getId()});
        }
        fileInfo.setBucket(bucket);
        UserUtil.setTenantId((UuIdEntity)fileInfo);
        this.handleDirectory(bucket, fileInfo);
        this.handleExtension(fileInfo);
        fileInfo.setCompleted(Boolean.valueOf(false));
        fileInfo.setCoverDate(LocalDateTime.now());
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        fileInfo.setUploadDate(new Date());
        fileInfo.setBucketName(bucket);
        if (this.envProperties.getDenyExtensions().contains(fileInfo.getExtension())) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_DENY, new Object[]{fileInfo.getExtension()});
        }
    }

    private void handleDirectory(String bucket, FileInfo fileInfo) {
        String dirId = IdUtil.getDirectoryId((String)fileInfo.getDirectoryId());
        if ("00000000-0000-0000-0000-000000000000".equals(dirId)) {
            if (StrUtils.isEmpty((String)fileInfo.getDirectoryName())) {
                fileInfo.setDirectoryId(dirId);
                fileInfo.setDirectoryName(I18nCode.DMC_DIR_ROOT.getMessage());
            } else {
                DirInfo dirInfo = this.directoryNodeService.insertByNamePath(bucket, BaseField.EMPTY_UUID, fileInfo.getDirectoryName());
                fileInfo.setDirectoryId(dirInfo.getId().toString());
                fileInfo.setDirectoryName(dirInfo.getName());
            }
        } else {
            UUID dirUuid = IdUtil.uuidOrNull((Object)dirId);
            if (dirUuid == null) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NONE, new Object[]{dirId});
            }
            DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirUuid);
            if (dirInfo == null) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NONE, new Object[]{dirId});
            }
            fileInfo.setDirectoryName(dirInfo.getName());
        }
    }

    private void handleExtension(FileInfo fileInfo) {
        String fileName = fileInfo.getFileName();
        String baseName = FileUtil.getBaseName((String)fileName);
        String extension = FileUtil.getExtension((String)fileName);
        String customExtension = FileUtil.trimExtension((String)fileInfo.getExtension());
        if (extension != null && customExtension != null && !extension.equals(customExtension)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_EXTENSION_NOT_SAME);
        }
        if (extension != null) {
            fileInfo.setFileName(baseName + "." + extension);
            fileInfo.setExtension(extension);
        } else if (customExtension != null) {
            fileInfo.setFileName(baseName + "." + customExtension);
            fileInfo.setExtension(customExtension);
        }
        if (fileInfo.getDisplayName() == null) {
            fileInfo.setDisplayName(baseName);
        }
        if (fileInfo.getDescription() == null) {
            fileInfo.setDescription(baseName);
        }
        if (fileInfo.getContentType() == null) {
            fileInfo.setContentType(FileUtil.getContentType((String)fileInfo.getFileName()));
        }
    }

    public void fillDirName(String bucket, FileInfo fileInfo) {
        if (fileInfo == null) {
            return;
        }
        if ("00000000-0000-0000-0000-000000000000".equals(fileInfo.getDirectoryId())) {
            fileInfo.setDirectoryName(I18nCode.DMC_DIR_ROOT.getMessage());
        } else {
            DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, fileInfo.getDirectoryId());
            fileInfo.setDirectoryName(dirInfo == null ? null : dirInfo.getName());
        }
    }

    public void fillDirName(String bucket, List<FileInfo> fileInfos) {
        List dirIds = IdUtil.validUuid(fileInfos.stream().map(FileInfo::getDirectoryId).distinct().collect(Collectors.toList()));
        List dirInfos = this.directoryNodeService.findByIds(bucket, dirIds);
        Map<String, String> dirNameMap = dirInfos.stream().collect(Collectors.toMap(dirInfo -> dirInfo.getId().toString(), DirInfo::getName, (a, b) -> b));
        dirNameMap.put("00000000-0000-0000-0000-000000000000", I18nCode.DMC_DIR_ROOT.getMessage());
        fileInfos.forEach(fileInfo -> fileInfo.setDirectoryName((String)dirNameMap.get(fileInfo.getDirectoryId())));
    }
}

