/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.domain.enumeration.MimeType;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileLogService;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.support.security.RSAAESDownloadResponseEncryptor;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class FileDownloadServiceImpl
implements FileDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(FileDownloadServiceImpl.class);
    private static final Long PARTIAL_SIZE = 2L * DataUtil.MB;
    @Autowired
    private FileLogService fileLogService;
    @Autowired
    private FileStorageFactory fileStorageFactory;
    @Autowired
    private FileNodeService fileNodeService;

    public byte[] downloadToBytes(String bucket, String fileInfoId) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileInfoId);
        return this.downloadToBytes(bucket, fileInfo);
    }

    public byte[] downloadToBytes(String bucket, @NonNull FileInfo fileInfo) {
        this.fileLogService.accessCount(bucket, fileInfo);
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        return fileStorage.downloadToBytes(fileInfo);
    }

    public byte[] downloadToBytes(String bucket, String fileInfoId, HttpServletRequest request, HttpServletResponse response) {
        byte[] bytes = this.downloadToBytes(bucket, fileInfoId);
        RSAAESDownloadResponseEncryptor encryptor = new RSAAESDownloadResponseEncryptor(bytes, request, response);
        return encryptor.encrypt();
    }

    public void downloadFile(String bucket, String fileInfoId, InlineAttachment type, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileInfoId);
        long downloadSize = this.downloadFile(bucket, fileInfo, type, request, response);
        if (downloadSize == fileInfo.getSize()) {
            this.fileLogService.accessCount(bucket, fileInfo);
        }
    }

    public void downloadFile(String bucket, String dirId, String fileName, InlineAttachment type, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, dirId, fileName);
        long downloadSize = this.downloadFile(bucket, fileInfo, type, request, response);
        if (downloadSize == fileInfo.getSize()) {
            this.fileLogService.accessCount(bucket, fileInfo);
        }
    }

    public void downloadFile(String bucket, String fileInfoId, long position, long length, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileInfoId);
        try {
            if (position + length == fileInfo.getSize()) {
                this.fileLogService.accessCount(bucket, fileInfo);
            }
            this.downloadToStream(bucket, fileInfo, position, length, request, response);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, new Object[]{fileInfoId});
        }
        finally {
            try {
                if (response != null && response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public long downloadFile(String bucket, FileInfo fileInfo, InlineAttachment type, HttpServletRequest request, HttpServletResponse response) {
        try {
            String fileName = URLEncoder.encode(fileInfo.getFileName(), StandardCharsets.UTF_8.name());
            response.setContentType(MimeType.parse((String)fileInfo.getContentType()).toString());
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", fileName);
            response.setHeader("Last-Modified", Instant.now().toString());
            response.setHeader("Content-Disposition", String.format("%s; filename=%s", type.name(), fileName));
            response.setHeader("Access-Control-Expose-Headers", "Accept-Ranges,Content-Range");
            response.setHeader("Access-Control-Allow-Headers", "Range,Content-Type");
            long fileSize = fileInfo.getSize();
            List httpRanges = HttpRange.parseRanges((String)request.getHeader("Range"));
            if (httpRanges.isEmpty()) {
                response.setHeader("Content-Length", String.valueOf(fileSize));
                response.setHeader("ContentLength", String.valueOf(fileSize));
                this.downloadToStream(bucket, fileInfo, 0L, fileSize, request, response);
                return fileSize;
            }
            HttpRange httpRange = (HttpRange)httpRanges.get(0);
            long start = httpRange.getRangeStart(fileSize);
            long end = httpRange.getRangeEnd(fileSize);
            long contentLength = end - start + 1L;
            String method = request.getMethod();
            if (HttpMethod.HEAD.matches(method)) {
                response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + fileSize);
                response.setStatus(206);
                response.setHeader("Content-Length", String.valueOf(contentLength));
                return 0L;
            }
            if (contentLength > PARTIAL_SIZE) {
                end = start + PARTIAL_SIZE - 1L;
                contentLength = PARTIAL_SIZE;
            }
            response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + fileSize);
            response.setStatus(206);
            response.setHeader("Content-Length", String.valueOf(contentLength));
            response.setHeader("ContentLength", String.valueOf(contentLength));
            this.downloadToStream(bucket, fileInfo, start, contentLength, request, response);
            return start + contentLength;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, new Object[]{fileInfo.getFileName()}, e.getMessage());
        }
    }

    private void downloadToStream(String bucket, FileInfo fileInfo, long position, long length, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        if (position == 0L && length == fileInfo.getSize()) {
            fileStorage.downloadToStream(fileInfo, (OutputStream)byteArrayOutputStream);
        } else {
            fileStorage.downloadPartToStream(fileInfo, (OutputStream)byteArrayOutputStream, position, length);
        }
        byteArrayOutputStream.flush();
        RSAAESDownloadResponseEncryptor encryptor = new RSAAESDownloadResponseEncryptor(byteArrayOutputStream.toByteArray(), request, response);
        encryptor.encrypt();
    }
}

