/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.domain.v2.DelFid;
import com.digiwin.dap.middleware.dmc.domain.v2.FileTree;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileHandlerService;
import com.digiwin.dap.middleware.dmc.support.security.RSAAESDownloadResponseEncryptor;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileHandlerServiceImpl
implements FileHandlerService {
    private static final Logger logger = LoggerFactory.getLogger(FileHandlerServiceImpl.class);
    @Autowired
    private FileDownloadService fileDownloadService;
    @Autowired
    private FileNodeService fileNodeService;

    public List<FileTree> getFileTrees(String bucket, BatchFid body) {
        body.afterPropertiesSet();
        ArrayList<FileTree> fileTrees = new ArrayList<FileTree>();
        for (String fileId : body.getFileIds()) {
            FileTree fileTree;
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileId);
            if (fileInfo == null) {
                fileTree = FileTree.fail((UUID)IdUtil.uuid((String)fileId), (String)I18nError.FILE_NONE.getMessage(new Object[]{fileId}));
                fileTrees.add(fileTree);
                continue;
            }
            fileTree = FileTree.ok((UUID)fileInfo.getId(), (String)fileInfo.getFileName());
            fileTree.setFilePath(fileInfo.getFileName());
            fileTrees.add(fileTree);
        }
        for (String directoryId : body.getDirIds()) {
            FileTree dirTree = this.fileNodeService.findFileTree(bucket, directoryId, null);
            fileTrees.add(dirTree);
        }
        this.checkFileTrees(DelFid.ok(), fileTrees);
        return fileTrees;
    }

    public void checkFileTrees(DelFid delFids, List<FileTree> fileTrees) {
        this.checkFileTrees(delFids, fileTrees, true);
    }

    private void checkFileTrees(DelFid delFids, List<FileTree> fileTrees, boolean exception) {
        for (FileTree fileTree : fileTrees) {
            if (fileTree.isDirectory()) {
                if (fileTree.isDeleted()) {
                    delFids.addDirId(fileTree.getFileId());
                    continue;
                }
                this.checkFileTrees(delFids, fileTree.getFiles(), false);
                continue;
            }
            if (!fileTree.isDeleted()) continue;
            delFids.addFileId(fileTree.getFileId());
        }
        if (exception && delFids.isNotEmpty()) {
            throw new BusinessException(I18nError.FILE_NONE.getMessage(new Object[]{delFids}));
        }
    }

    public String getFileName(List<FileTree> fileTrees) {
        String fileName = String.format("\u6279\u91cf\u4e0b\u8f7d[%s]", DateTimeFormatter.ofPattern("yyyy-MM-dd").format(LocalDateTime.now()));
        int size = fileTrees.size();
        if (size == 1) {
            fileName = fileTrees.get(0).getFileName();
        } else {
            Optional<FileTree> dir = fileTrees.stream().filter(FileTree::isDirectory).findFirst();
            if (dir.isPresent()) {
                fileName = dir.get().getFileName();
            } else {
                Optional file = fileTrees.stream().findFirst();
                if (file.isPresent()) {
                    fileName = FileUtil.getBaseName((String)((FileTree)file.get()).getFileName());
                }
            }
        }
        return fileName + ".zip";
    }

    public void compressFile(String bucket, List<FileTree> fileTrees, String zipFileName, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(zipFileName, "UTF-8"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipArchiveOutputStream zipOs = new ZipArchiveOutputStream((OutputStream)byteArrayOutputStream);
            zipOs.setUseZip64(Zip64Mode.AsNeeded);
            this.getArchiveEntry(zipOs, bucket, fileTrees);
            zipOs.close();
            byteArrayOutputStream.close();
            RSAAESDownloadResponseEncryptor encryptor = new RSAAESDownloadResponseEncryptor(byteArrayOutputStream.toByteArray(), request, response);
            encryptor.encrypt();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_ZIP_FAIL, new Object[]{zipFileName});
        }
    }

    private void getArchiveEntry(ZipArchiveOutputStream zipOs, String bucket, List<FileTree> fileTrees) {
        HashMap dupNames = new HashMap();
        for (FileTree fileTree : fileTrees) {
            this.getArchiveEntry(zipOs, bucket, fileTree, dupNames);
        }
    }

    private void getArchiveEntry(ZipArchiveOutputStream zipOs, String bucket, FileTree fileTree, Map<String, Integer> dupNames) {
        if (fileTree.isDirectory()) {
            String filePath = fileTree.getFilePath();
            fileTree.setFilePath(filePath.endsWith(File.separator) ? filePath : filePath + File.separator);
            this.archiveEntry(zipOs, bucket, fileTree);
            HashMap dirDupNames = new HashMap();
            for (FileTree tree : fileTree.getFiles()) {
                this.getArchiveEntry(zipOs, bucket, tree, dirDupNames);
            }
        } else {
            fileTree.setFilePath(FileUtil.getDupName(dupNames, (String)fileTree.getFilePath()));
            this.archiveEntry(zipOs, bucket, fileTree);
        }
    }

    private void archiveEntry(ZipArchiveOutputStream zipOs, String bucket, FileTree fileTree) {
        try {
            ZipArchiveEntry entry = new ZipArchiveEntry(fileTree.getFilePath());
            zipOs.putArchiveEntry((ArchiveEntry)entry);
            if (!fileTree.isDirectory()) {
                byte[] fileBytes = this.fileDownloadService.downloadToBytes(bucket, fileTree.getFileId().toString());
                zipOs.write(fileBytes);
            }
            zipOs.closeArchiveEntry();
        }
        catch (Exception e) {
            logger.error(String.format("%s[%s]\u521b\u5efa\u538b\u7f29\u6587\u4ef6\u6761\u76ee\u5931\u8d25", fileTree.getFileName(), fileTree.getFileId()), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_ZIP_FAIL, new Object[]{fileTree.getFileName()});
        }
    }
}

