/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.base.BaseDatabaseManager;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.domain.select.ImageOption;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsDeletion;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsExtension;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsFile;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsMigration;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileInfoStatServiceImpl
extends BaseDatabaseManager<FileInfo>
implements FileInfoStatService {
    @Autowired
    private EnvProperties envProperties;

    protected String getCollectionName() {
        return ".fileInfos";
    }

    protected Class<FileInfo> getEntityClass() {
        return FileInfo.class;
    }

    public PageData<ImageOption> getImageByPage(String bucket, Page query) {
        Page page = query == null ? Page.empty() : query;
        Bson condFilter = page.filter();
        Bson imageFilter = Filters.or((Bson[])new Bson[]{Filters.eq((String)"contentType", (Object)"image/jpeg"), Filters.eq((String)"contentType", (Object)"image/png"), Filters.eq((String)"contentType", (Object)"image/bmp"), Filters.eq((String)"contentType", (Object)"image/gif")});
        Bson filter = Filters.and((Bson[])new Bson[]{imageFilter, condFilter});
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        long total = mongoCollection.countDocuments(filter);
        if (total <= 0L) {
            return PageData.zero();
        }
        MongoCursor iterator = mongoCollection.find(filter).sort(page.sort()).skip(page.skip()).limit(page.limit()).iterator();
        ArrayList<ImageOption> lists = new ArrayList<ImageOption>();
        while (iterator.hasNext()) {
            FileInfo fileInfo = (FileInfo)iterator.next();
            ImageOption option = new ImageOption();
            option.setFileId(fileInfo.getId());
            option.setFileName(fileInfo.getFileName());
            option.setUri(String.format("%s/api/dmc/v2/file/%s/preview/%s", this.envProperties.getDmcUri(), bucket, fileInfo.getId()));
            lists.add(option);
        }
        return PageData.data((long)total, lists);
    }

    public long countByRange(String bucket, long start, long end) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        return mongoCollection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.gte((String)"size", (Object)start), Filters.lt((String)"size", (Object)end)}));
    }

    public StatsFile fileStats(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Bson group = Aggregates.group(null, (BsonField[])new BsonField[]{Accumulators.sum((String)"size", (Object)"$size"), Accumulators.sum((String)"count", (Object)1)});
        Bson projection = Aggregates.project((Bson)new Document("size", (Object)"$size").append("count", (Object)"$count").append("bucket", (Object)bucket).append("_id", (Object)false));
        return (StatsFile)mongoCollection.aggregate(Arrays.asList(group, projection), StatsFile.class).first();
    }

    public BucketStats fileStatsByDeletion(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Document groupId = new Document("$ifNull", Arrays.asList("$deletion", 0));
        Bson group = Aggregates.group((Object)groupId, (BsonField[])new BsonField[]{Accumulators.sum((String)"size", (Object)"$size"), Accumulators.sum((String)"count", (Object)1)});
        Bson projection = Aggregates.project((Bson)new Document("deletion", (Object)"$_id").append("size", (Object)"$size").append("count", (Object)"$count").append("bucket", (Object)bucket).append("_id", (Object)false));
        List results = (List)mongoCollection.aggregate(Arrays.asList(group, projection), StatsDeletion.class).into(new ArrayList());
        StatsDeletion statsDeletion = results.stream().filter(p -> (long)p.getDeletion().intValue() == 0L).findFirst().orElse(null);
        BucketStats result = new BucketStats();
        result.setName(bucket);
        result.setTotalSize(results.stream().mapToLong(StatsFile::getSize).sum());
        result.setTotalCount(results.stream().mapToLong(StatsFile::getCount).sum());
        result.setFileSize(statsDeletion == null ? 0L : statsDeletion.getSize());
        result.setFileCount(statsDeletion == null ? 0L : statsDeletion.getCount());
        result.setDeleteSize(result.getTotalSize() - result.getFileSize());
        result.setDeleteCount(result.getTotalCount() - result.getFileCount());
        return result;
    }

    public List<StatsTenant> fileStatsByTenant(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Document document = new Document("$ifNull", Arrays.asList("$tenantId", ""));
        Bson group = Aggregates.group((Object)document, (BsonField[])new BsonField[]{Accumulators.sum((String)"size", (Object)"$size"), Accumulators.sum((String)"count", (Object)1)});
        Bson projection = Aggregates.project((Bson)new Document("tenantId", (Object)"$_id").append("size", (Object)"$size").append("count", (Object)"$count").append("bucket", (Object)bucket).append("_id", (Object)false));
        return (List)mongoCollection.aggregate(Arrays.asList(group, projection), StatsTenant.class).into(new ArrayList());
    }

    public List<StatsMigration> fileStatsByMigration(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Document document = new Document("$ifNull", Arrays.asList("$migration", Boolean.FALSE));
        Bson group = Aggregates.group((Object)document, (BsonField[])new BsonField[]{Accumulators.sum((String)"size", (Object)"$size"), Accumulators.sum((String)"count", (Object)1)});
        Bson projection = Aggregates.project((Bson)new Document("migration", (Object)"$_id").append("size", (Object)"$size").append("count", (Object)"$count").append("bucket", (Object)bucket).append("_id", (Object)false));
        Bson match = Aggregates.match((Bson)BsonUtil.normal());
        return (List)mongoCollection.aggregate(Arrays.asList(match, group, projection), StatsMigration.class).into(new ArrayList());
    }

    public List<StatsExtension> fileStatsByType(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Document document = new Document("$ifNull", Arrays.asList("$extension", ""));
        Bson group = Aggregates.group((Object)document, (BsonField[])new BsonField[]{Accumulators.sum((String)"size", (Object)"$size"), Accumulators.sum((String)"count", (Object)1)});
        Bson projection = Aggregates.project((Bson)new Document("extension", (Object)"$_id").append("size", (Object)"$size").append("count", (Object)"$count").append("bucket", (Object)bucket).append("_id", (Object)false));
        return (List)mongoCollection.aggregate(Arrays.asList(group, projection), StatsExtension.class).into(new ArrayList());
    }

    public FileInfo getFileInfoByUser(String bucket, String fileInfoId, String userName) {
        MongoCollection mongoCollection = this.getAnonymousUserCollection(bucket, userName);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)IdUtil.uuid((String)fileInfoId)), BsonUtil.normal()});
        FileInfo fileInfo = (FileInfo)mongoCollection.find(filter).first();
        if (fileInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{fileInfoId});
        }
        return fileInfo;
    }

    public long migrationCount(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"storage", (Object)StorageEnum.MongoDB), Filters.eq((String)"storage", null)}), Filters.eq((String)"migration", null)});
        return mongoCollection.countDocuments(filter);
    }

    public long switchCount(String bucket) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"storage", (Object)StorageEnum.MongoDB), Filters.eq((String)"migration", (Object)true)});
        return mongoCollection.countDocuments(filter);
    }
}

