/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileOp;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsDiskLog;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsVisitLog;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskLogRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitLogRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileLogService;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileLogServiceImpl
implements FileLogService {
    private static final Map<String, Bucket> bucketCache = new ConcurrentHashMap();
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private StatsDiskLogRepository statsDiskLogRepository;
    @Autowired
    private StatsVisitLogRepository statsVisitLogRepository;

    public void accessCount(String bucket, FileInfo fileInfo) {
        if (fileInfo == null || fileInfo.getId() == BaseField.EMPTY_UUID) {
            this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u56fe\u7247\u5904\u7406\u670d\u52a1", (Object)fileInfo);
            return;
        }
        this.fileInfoCrudService.visits(bucket, fileInfo.getId());
        this.accessLog(fileInfo);
    }

    public void fileOpRemove(String bucket, FileInfo fileInfo) {
        fileInfo.setBucket(bucket);
        this.fileOpLog(FileOp.Remove, fileInfo);
    }

    public void fileOpLog(FileOp fileOp, FileInfo fileInfo) {
        StatsDiskLog diskLog = new StatsDiskLog();
        diskLog.setType(fileOp.name());
        diskLog.setAppId(this.getAppId(fileInfo.getBucket()));
        diskLog.setBucket(fileInfo.getBucket());
        diskLog.setTenantId(TenantUtil.getOrEmpty((String)fileInfo.getTenantId()));
        diskLog.setFileId(fileInfo.getId().toString());
        diskLog.setSize(Long.valueOf(fileInfo.getSize()));
        this.statsDiskLogRepository.insert((ObIdEntity)diskLog);
    }

    private void accessLog(FileInfo fileInfo) {
        StatsVisitLog visitLog = new StatsVisitLog();
        visitLog.setAppId(this.getAppId(fileInfo.getBucket()));
        visitLog.setBucket(fileInfo.getBucket());
        visitLog.setTenantId(TenantUtil.getOrEmpty((String)fileInfo.getTenantId()));
        visitLog.setFileId(fileInfo.getId().toString());
        visitLog.setSize(Long.valueOf(fileInfo.getSize()));
        this.statsVisitLogRepository.insert((ObIdEntity)visitLog);
    }

    public String getAppId(String bucketName) {
        if (bucketName == null) {
            return null;
        }
        Bucket bucket = (Bucket)bucketCache.get(bucketName);
        if (bucket != null) {
            return bucket.getAppId();
        }
        bucket = this.bucketRepository.findByName(bucketName);
        if (bucket != null) {
            bucketCache.put(bucketName, bucket);
            return bucket.getAppId();
        }
        return null;
    }
}

