/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.RecycleCrudService;
import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.dao.ShrinkCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.VersionTag;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.RecycleBin;
import com.digiwin.dap.middleware.dmc.obsolete.service.ImageCacheFileService;
import com.digiwin.dap.middleware.dmc.obsolete.service.RecycleBinV1Service;
import com.digiwin.dap.middleware.dmc.service.business.FileLogService;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.support.context.BucketContextHolder;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class FileRecycleServiceImpl
implements FileRecycleService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private FileLogService fileLogService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private ShareCrudService shareCrudService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private ShrinkCrudService shrinkCrudService;
    @Autowired
    private RecycleCrudService recycleCrudService;
    @Autowired
    private RecycleBinV1Service recycleBinV1Service;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private DirectoryNodeService directoryNodeService;
    @Autowired
    private DirectoryCrudService directoryCrudService;
    @Autowired
    private ImageCacheFileService imageCacheFileService;

    public RecycleBin removeFile(String bucket, UUID fileInfoId) {
        return this.removeFile(bucket, fileInfoId, BucketContextHolder.isShrink());
    }

    private RecycleBin removeFile(String bucket, UUID fileInfoId, boolean shrink) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        if (fileInfo == null) {
            return null;
        }
        RecycleBin recycleBin = new RecycleBin();
        recycleBin.setFileId(fileInfo.getId());
        recycleBin.setName(fileInfo.getFileName());
        recycleBin.setDeleteDate(LocalDateTime.now());
        recycleBin.setSize(fileInfo.getSize());
        recycleBin.setContentType(FileTypeEnum.File.name());
        recycleBin.setVersion(VersionTag.V2.name());
        recycleBin.setBucket(bucket);
        recycleBin.setDeleteTime(new Date());
        UserUtil.copyCreate((UuIdEntity)recycleBin, (UuIdEntity)fileInfo);
        UUID dirId = IdUtil.uuid((String)fileInfo.getDirectoryId());
        List dirInfos = this.getPath(bucket, dirId);
        recycleBin.setPath(dirInfos);
        recycleBin.setPaths(FileUtil.getPaths((UUID)dirId, (List)dirInfos, (boolean)true));
        this.recycleCrudService.save((UuIdEntity)recycleBin);
        this.removeFile(bucket, (UuIdEntity)fileInfo, FileTypeEnum.File);
        if (shrink) {
            List shrinkInfos = this.shrinkCrudService.findBySourceId(bucket, fileInfoId.toString());
            shrinkInfos.forEach(p -> this.removeFile(bucket, IdUtil.uuid((String)p.getTargetId()), false));
        }
        return recycleBin;
    }

    public RecycleBin removeDir(String bucket, UUID dirId) {
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirId);
        if (dirInfo == null || dirId == BaseField.EMPTY_UUID) {
            return null;
        }
        RecycleBin recycleBin = new RecycleBin();
        recycleBin.setFileId(dirInfo.getId());
        recycleBin.setName(dirInfo.getName());
        recycleBin.setDeleteDate(LocalDateTime.now());
        recycleBin.setContentType(FileTypeEnum.Directory.name());
        recycleBin.setVersion(VersionTag.V2.name());
        recycleBin.setBucket(bucket);
        UserUtil.copyCreate((UuIdEntity)recycleBin, (UuIdEntity)dirInfo);
        List dirInfos = this.getPath(bucket, dirId);
        recycleBin.setPath(dirInfos);
        recycleBin.setPaths(FileUtil.getPaths((UUID)dirId, (List)dirInfos, (boolean)true));
        this.recycleCrudService.save((UuIdEntity)recycleBin);
        this.removeFile(bucket, (UuIdEntity)dirInfo, FileTypeEnum.Directory);
        return recycleBin;
    }

    private List<DirInfo> getPath(String bucket, UUID dirId) {
        if (BaseField.EMPTY_UUID.equals(dirId)) {
            return new ArrayList<DirInfo>();
        }
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirId);
        if (dirInfo == null) {
            return new ArrayList<DirInfo>();
        }
        List dirInfos = this.getPath(bucket, dirInfo.getParentId());
        dirInfos.add(dirInfo);
        return dirInfos;
    }

    private void removeFile(String bucket, UuIdEntity entity, FileTypeEnum fileType) {
        if (fileType == FileTypeEnum.File) {
            this.fileNodeService.increment(bucket, entity.getId());
            this.fileLogService.fileOpRemove(bucket, (FileInfo)entity);
        } else if (fileType == FileTypeEnum.Directory) {
            if (entity.getDeletion() == null || entity.getDeletion() <= 0L) {
                this.fileNodeService.incrementByDirId(bucket, entity.getId());
                List dirInfos = this.directoryCrudService.findByParentId(bucket, entity.getId());
                for (DirInfo child : dirInfos) {
                    this.removeFile(bucket, (UuIdEntity)child, FileTypeEnum.Directory);
                }
            }
            this.directoryNodeService.increment(bucket, entity.getId());
        }
    }

    public void restoreRecycleBin(String bucket, UUID recycleBinId) {
        RecycleBin recycleBin = (RecycleBin)this.recycleCrudService.findById(bucket, recycleBinId);
        this.restore(bucket, recycleBin);
    }

    public void restoreFile(String bucket, UUID fileInfoId) {
        RecycleBin recycleBin = this.recycleCrudService.findByFileId(bucket, fileInfoId);
        this.restore(bucket, recycleBin);
    }

    private void restore(String bucket, RecycleBin recycleBin) {
        if (recycleBin == null) {
            return;
        }
        if (VersionTag.V2.name().equals(recycleBin.getVersion())) {
            this.restoreRecycleBinV2(bucket, recycleBin);
        } else {
            this.recycleBinV1Service.restoreRecycleBinV1(bucket, recycleBin);
        }
    }

    public void restoreRecycleBinV2(String bucket, RecycleBin recycleBin) {
        if (FileTypeEnum.File.name().equals(recycleBin.getContentType())) {
            FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, recycleBin.getFileId());
            if (fileInfo != null) {
                this.restoreDirUp(bucket, recycleBin.getPath());
                this.fileNodeService.decrementToZero(bucket, fileInfo.getId());
            }
        } else if (FileTypeEnum.Directory.name().equals(recycleBin.getContentType())) {
            this.restoreDirUp(bucket, recycleBin.getPath());
            this.restoreDirDown(bucket, recycleBin.getFileId());
        }
        this.recycleCrudService.deleteById(bucket, recycleBin.getId());
    }

    private void restoreDirUp(String bucket, List<DirInfo> parents) {
        for (DirInfo parent : parents) {
            DirInfo dirInfo = (DirInfo)this.directoryCrudService.findById(bucket, parent.getId());
            if (dirInfo != null) {
                this.directoryNodeService.decrementToZero(bucket, dirInfo.getId());
                continue;
            }
            parent.setDeletion(Long.valueOf(0L));
            this.directoryCrudService.save((UuIdEntity)parent);
        }
    }

    private void restoreDirDown(String bucket, UUID dirId) {
        this.fileNodeService.decrementByDirId(bucket, dirId);
        List dirInfos = this.directoryCrudService.findDeletedByParentId(bucket, dirId);
        for (DirInfo dirInfo : dirInfos) {
            if (dirInfo.getDeletion() == 1L) {
                this.restoreDirDown(bucket, dirInfo.getId());
                continue;
            }
            if (dirInfo.getDeletion() <= 1L) continue;
            this.directoryNodeService.decrement(bucket, dirInfo.getId());
        }
        this.directoryNodeService.decrement(bucket, dirId);
    }

    public void deleteRecycleBin(String bucket, UUID recycleBinId) {
        RecycleBin recycleBin = (RecycleBin)this.recycleCrudService.findById(bucket, recycleBinId);
        if (recycleBin == null) {
            return;
        }
        if (VersionTag.V2.name().equals(recycleBin.getVersion())) {
            this.deleteRecycleBinV2(bucket, recycleBin);
        } else {
            this.recycleBinV1Service.deleteRecycleBinV1(bucket, recycleBin);
        }
    }

    public void deleteRecycleBinV2(String bucket, RecycleBin recycleBin) {
        DirInfo dirInfo;
        FileInfo fileInfo;
        if (FileTypeEnum.File.name().equals(recycleBin.getContentType()) && (fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, recycleBin.getFileId())) != null) {
            this.deleteFile(bucket, (UuIdEntity)fileInfo, FileTypeEnum.File, true);
        }
        if (FileTypeEnum.Directory.name().equals(recycleBin.getContentType()) && (dirInfo = (DirInfo)this.directoryCrudService.findById(bucket, recycleBin.getFileId())) != null) {
            this.deleteFile(bucket, (UuIdEntity)dirInfo, FileTypeEnum.Directory, true);
        }
        this.recycleCrudService.deleteById(bucket, recycleBin.getId());
    }

    private void deleteFile(String bucket, UuIdEntity entity, FileTypeEnum fileType, boolean root) {
        if (fileType == FileTypeEnum.File) {
            if (root || entity.getDeletion() == 1L) {
                this.doDeleteFile(bucket, (FileInfo)entity);
            } else if (entity.getDeletion() > 1L) {
                this.fileNodeService.decrement(bucket, entity.getId());
            }
        } else if (fileType == FileTypeEnum.Directory) {
            List fileInfos = this.fileInfoCrudService.findDeletedByDirId(bucket, entity.getId());
            for (FileInfo fileInfo : fileInfos) {
                this.deleteFile(bucket, (UuIdEntity)fileInfo, FileTypeEnum.File, false);
            }
            List dirInfos = this.directoryCrudService.findDeletedByParentId(bucket, entity.getId());
            for (DirInfo dirInfo : dirInfos) {
                if (dirInfo.getDeletion() == 1L) {
                    this.deleteFile(bucket, (UuIdEntity)dirInfo, FileTypeEnum.Directory, false);
                    continue;
                }
                if (dirInfo.getDeletion() <= 1L) continue;
                this.directoryNodeService.decrement(bucket, dirInfo.getId());
            }
            this.directoryCrudService.deleteById(bucket, entity.getId());
        }
    }

    private void doDeleteFile(String bucket, @NonNull FileInfo fileInfo) {
        this.fileInfoCrudService.deleteById(bucket, fileInfo.getId());
        this.shareCrudService.deleteByFileId(bucket, fileInfo.getId().toString());
        this.shrinkCrudService.deleteByTargetId(bucket, fileInfo.getId().toString());
        if (DeployAreaEnum.isDev((String)this.envProperties.getDeployArea())) {
            this.imageCacheFileService.deleteByImageId(bucket, fileInfo.getId().toString());
        }
        this.fileUploadService.deleteFile(bucket, fileInfo);
    }

    public void clearRecycleBin(String bucket) {
        List recycleBins = this.recycleCrudService.findAll(bucket);
        for (RecycleBin recycleBin : recycleBins) {
            this.deleteRecycleBin(bucket, recycleBin.getId());
        }
    }
}

