/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.domain.v2.FileOpTree;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.support.context.FileOpTreeContextHolder;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private DirectoryNodeService directoryNodeService;
    @Autowired
    private DirectoryCrudService directoryCrudService;

    public void moveFile(String bucket, UUID fileInfoId, UUID directoryId) {
        FileInfo fileInfo = this.fileOpCheck(bucket, fileInfoId, directoryId);
        if (Objects.equals(fileInfo.getDirectoryId(), directoryId.toString())) {
            return;
        }
        fileInfo.setFileName(this.getDupFileName(bucket, fileInfo, fileInfo.getId(), directoryId));
        fileInfo.setDirectoryId(directoryId.toString());
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void moveDir(String bucket, UUID dirId, UUID targetDirId) {
        DirInfo dirInfo = this.dirOpCheck(bucket, dirId, targetDirId);
        if (dirInfo.getParentId().equals(targetDirId)) {
            return;
        }
        dirInfo.setName(this.getDupDirName(bucket, dirInfo, dirId, targetDirId));
        dirInfo.setParentId(targetDirId);
        dirInfo.setBucket(bucket);
        this.directoryCrudService.update((UuIdEntity)dirInfo);
    }

    public String copyFile(String bucket, UUID fileInfoId, UUID directoryId) {
        FileInfo fileInfo = this.fileOpCheck(bucket, fileInfoId, directoryId);
        FileOpTree fileOpTree = this.copyFile0(bucket, fileInfo, directoryId);
        FileOpTreeContextHolder.getContext().add(fileOpTree);
        return fileOpTree.getTargetId().toString();
    }

    private FileOpTree copyFile0(String bucket, FileInfo fileInfo, UUID directoryId) {
        try {
            FileInfo newFileInfo = fileInfo.clone();
            newFileInfo.setId(UUID.randomUUID());
            newFileInfo.setDirectoryId(directoryId.toString());
            newFileInfo.setBucket(bucket);
            this.fileInfoCrudService.insert((UuIdEntity)newFileInfo);
            return FileOpTree.fileOpOk((UUID)fileInfo.getId(), (UUID)newFileInfo.getId());
        }
        catch (Exception e) {
            return FileOpTree.fileOpFail((UUID)fileInfo.getId(), (String)e.getMessage());
        }
    }

    public String copyDir(String bucket, UUID dirId, UUID targetDirId) {
        DirInfo dirInfo = this.dirOpCheck(bucket, dirId, targetDirId);
        DirInfo newDirInfo = dirInfo.clone();
        newDirInfo.setId(UUID.randomUUID());
        newDirInfo.setName(this.getDupDirName(bucket, dirInfo, newDirInfo.getId(), targetDirId));
        newDirInfo.setParentId(targetDirId);
        this.directoryCrudService.insert((UuIdEntity)newDirInfo);
        FileOpTree dirOpTree = this.copyDir0(bucket, dirId, newDirInfo.getId());
        FileOpTreeContextHolder.getContext().add(dirOpTree);
        return newDirInfo.getId().toString();
    }

    private FileOpTree copyDir0(String bucket, UUID dirId, UUID newDirId) {
        FileOpTree fileOpTree = FileOpTree.dirOpOk((UUID)dirId, (UUID)newDirId);
        List fileInfos = this.fileNodeService.findByDirId(bucket, dirId.toString());
        for (FileInfo fileInfo : fileInfos) {
            FileOpTree fileOp = this.copyFile0(bucket, fileInfo, newDirId);
            fileOpTree.getFileOps().add(fileOp);
        }
        List dirInfos = this.directoryNodeService.findByParentId(bucket, dirId);
        for (DirInfo dirInfo : dirInfos) {
            DirInfo newDirInfo = dirInfo.clone();
            newDirInfo.setId(UUID.randomUUID());
            newDirInfo.setParentId(newDirId);
            newDirInfo.setBucket(bucket);
            this.directoryCrudService.insert((UuIdEntity)newDirInfo);
            FileOpTree dirOp = this.copyDir0(bucket, dirInfo.getId(), newDirInfo.getId());
            fileOpTree.getFileOps().add(dirOp);
        }
        return fileOpTree;
    }

    private FileInfo fileOpCheck(String bucket, UUID fileInfoId, UUID targetDirId) {
        if (!this.directoryNodeService.existsById(bucket, targetDirId)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NONE, new Object[]{targetDirId});
        }
        return this.fileNodeService.findOne(bucket, fileInfoId.toString());
    }

    public DirInfo dirOpCheck(String bucket, UUID dirId) {
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirId);
        if (dirInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NONE, new Object[]{dirId});
        }
        return dirInfo;
    }

    private DirInfo dirOpCheck(String bucket, UUID dirId, UUID targetDirId) {
        if (IdUtil.isRootDir((UUID)dirId)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_ROOT_DENY);
        }
        if (dirId.equals(targetDirId)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_SAME);
        }
        if (!this.directoryNodeService.existsById(bucket, targetDirId)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_NONE, new Object[]{targetDirId});
        }
        return this.dirOpCheck(bucket, dirId);
    }

    public List<FileOpTree> batchCopy(String bucket, BatchFid batchFid, UUID targetDirId) {
        for (String fileId : batchFid.getFileIds()) {
            try {
                this.copyFile(bucket, IdUtil.uuid((String)fileId), targetDirId);
            }
            catch (Exception e) {
                FileOpTree fileOpTree = FileOpTree.fileOpFail((UUID)IdUtil.uuid((String)fileId), (String)e.getMessage());
                FileOpTreeContextHolder.getContext().add(fileOpTree);
            }
        }
        for (String dirId : batchFid.getDirIds()) {
            try {
                this.copyDir(bucket, IdUtil.getDirId((String)dirId), targetDirId);
            }
            catch (Exception e) {
                FileOpTree dirOpTree = FileOpTree.dirOpFail((UUID)IdUtil.uuid((String)dirId), (String)e.getMessage());
                FileOpTreeContextHolder.getContext().add(dirOpTree);
            }
        }
        return FileOpTreeContextHolder.getContext();
    }

    private String getDupFileName(String bucket, FileInfo oldFile, UUID newId, UUID targetDirId) {
        FileInfo fileInfo = this.fileNodeService.findByFileName(bucket, targetDirId.toString(), oldFile.getFileName());
        if (fileInfo != null) {
            String fileNameNoExt = FileUtil.getBaseName((String)oldFile.getFileName());
            String fileName = fileNameNoExt.replace("_" + oldFile.getId().toString(), "");
            return fileName + "_" + newId + "." + oldFile.getExtension();
        }
        return oldFile.getFileName();
    }

    private String getDupDirName(String bucket, DirInfo oldDir, UUID newId, UUID targetDirId) {
        DirInfo dirInfo = this.directoryNodeService.findByName(bucket, targetDirId, oldDir.getName());
        if (dirInfo != null) {
            String dirName = oldDir.getName().replace("_" + oldDir.getId(), "");
            return dirName + "_" + newId;
        }
        return oldDir.getName();
    }
}

