/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.UploadStatus;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.FileCallbackData;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IOUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadServiceDecryptedDecorator
implements FileUploadService {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceDecryptedDecorator.class);
    private final FileUploadService fileUploadService;
    private final BucketRepository bucketRepository;
    private final boolean dmcSecurity;
    private final String digitalEnvelope;

    public FileUploadServiceDecryptedDecorator(FileUploadService fileUploadService, BucketRepository bucketRepository, boolean dmcSecurity, String digitalEnvelope) {
        this.fileUploadService = fileUploadService;
        this.bucketRepository = bucketRepository;
        this.dmcSecurity = dmcSecurity;
        this.digitalEnvelope = digitalEnvelope;
    }

    public String createEmptyFile(String bucket, FileInfo fileInfo) {
        return this.fileUploadService.createEmptyFile(bucket, fileInfo);
    }

    public void uploadFromStream(String bucket, String fileInfoId, byte[] source, long from, long to, long total, Integer partNum) {
        if (to < from) {
            throw new IllegalArgumentException("to \u5c0f\u4e8e from");
        }
        if (to >= total) {
            throw new IllegalArgumentException("to \u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e total");
        }
        long partSize = to - from + 1L;
        byte[] newSource = this.dmcSecurity ? this.decrypt(bucket, source) : source;
        if (partSize != (long)newSource.length) {
            throw new IllegalArgumentException("\u5206\u6bb5\u6587\u4ef6\u5927\u5c0f\u4e0e\u5b9e\u9645\u4f20\u8f93\u6587\u4ef6\u5927\u5c0f\u4e0d\u4e00\u81f4");
        }
        this.fileUploadService.uploadFromStream(bucket, fileInfoId, newSource, from, to, total, partNum);
    }

    public void coverEmptyFile(String bucket, String fileInfoId) {
        this.fileUploadService.coverEmptyFile(bucket, fileInfoId);
    }

    public FileInfo coverUploadFromStream(String bucket, String fileInfoId, InputStream source) {
        return this.fileUploadService.coverUploadFromStream(bucket, fileInfoId, this.dmcSecurity ? this.decrypt(bucket, source) : source);
    }

    public void editUpload(String bucket, FileCallbackData extra, InputStream source) {
        this.fileUploadService.editUpload(bucket, extra, this.dmcSecurity ? this.decrypt(bucket, source) : source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileInfo uploadFromFile(String bucket, FileInfo fileInfo, MultipartFile multipartFile) {
        try (InputStream inputStream = multipartFile.getInputStream();){
            if (fileInfo.getFileName() == null) {
                fileInfo.setFileName(multipartFile.getOriginalFilename());
            }
            if (fileInfo.getExtension() == null) {
                fileInfo.setExtension(FileUtil.getExtension((String)fileInfo.getFileName()));
            }
            if (fileInfo.getContentType() == null && !"application/octet-stream".equals(multipartFile.getContentType())) {
                fileInfo.setContentType(multipartFile.getContentType());
            }
            fileInfo.setSize(multipartFile.getSize());
            this.fileUploadService.uploadFromStream(bucket, fileInfo, this.dmcSecurity ? this.decrypt(bucket, inputStream) : inputStream);
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, fileInfo.getFileName());
        }
    }

    public FileInfo uploadFromStream(String bucket, FileInfo fileInfo, InputStream source) {
        return this.fileUploadService.uploadFromStream(bucket, fileInfo, this.dmcSecurity ? this.decrypt(bucket, source) : source);
    }

    public FileInfo uploadFromBytes(String bucket, FileInfo fileInfo, byte[] source) {
        return this.fileUploadService.uploadFromBytes(bucket, fileInfo, this.dmcSecurity ? this.decrypt(bucket, source) : source);
    }

    public UploadStatus getFileUploadStatus(String bucket, String fileInfoId) {
        return this.fileUploadService.getFileUploadStatus(bucket, fileInfoId);
    }

    public void deleteFile(String bucket, FileInfo fileInfo) {
        this.fileUploadService.deleteFile(bucket, fileInfo);
    }

    private byte[] decrypt(String bucket, byte[] bytes) {
        if (!StringUtils.hasLength((String)this.digitalEnvelope)) {
            throw new BusinessException("\u6570\u5b57\u4fe1\u5c01\u4e3a\u7a7a\u65e0\u6cd5\u89e3\u5bc6\u5bc6\u6587!");
        }
        Bucket bucketInfo = this.bucketRepository.findByName(bucket);
        byte[] aesKey = RSA.decryptOAEP((byte[])Base64.decode((String)this.digitalEnvelope), (String)bucketInfo.getPrivateKey());
        return AES.decryptIvCBC((byte[])bytes, (byte[])aesKey);
    }

    private InputStream decrypt(String bucket, InputStream inputStream) {
        if (!StringUtils.hasLength((String)this.digitalEnvelope)) {
            throw new BusinessException("\u6570\u5b57\u4fe1\u5c01\u4e3a\u7a7a\u65e0\u6cd5\u89e3\u5bc6\u5bc6\u6587!");
        }
        Bucket bucketInfo = this.bucketRepository.findByName(bucket);
        byte[] aesKey = RSA.decryptOAEP((byte[])Base64.decode((String)this.digitalEnvelope), (String)bucketInfo.getPrivateKey());
        byte[] ciphertext = IOUtils.inputStreamToByteArray((InputStream)inputStream);
        byte[] plaintext = AES.decryptIvCBC((byte[])ciphertext, (byte[])aesKey);
        try {
            return IOUtils.byteArrayToInputStream((byte[])plaintext);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
        }
    }
}

