/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.business.impl;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.BackupCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.UploadStatus;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileOp;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.domain.FileCallbackData;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.service.business.FileLogService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.support.HashingUploadWrapper;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.MongoGridFSException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileUploadServiceImpl
implements FileUploadService {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceImpl.class);
    @Autowired
    private FileLogService fileLogService;
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private FileStorageFactory fileStorageFactory;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private BackupCrudService backupCrudService;
    @Autowired
    private BucketService bucketService;

    public String createEmptyFile(String bucket, FileInfo fileInfo) {
        this.fidCheckService.fillAndCheck(bucket, fileInfo);
        FileStorage fileStorage = this.fileStorageFactory.selectStorage(bucket, fileInfo);
        fileStorage.createFile(fileInfo);
        return this.fileInfoCrudService.insert((UuIdEntity)fileInfo);
    }

    public void uploadFromStream(String bucket, String fileInfoId, byte[] source, long from, long to, long total, Integer partNum) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        if (fileInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{fileInfoId});
        }
        if (fileInfo.getSize() == 0L) {
            fileInfo.setSize(total);
            this.fileInfoCrudService.replace((UuIdEntity)fileInfo);
        }
        try {
            FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
            fileStorage.uploadFromStream(fileInfo, source, from, to, total, partNum);
            if (to == total - 1L) {
                HashingUploadWrapper.of().uploadFromStream(fileStorage, fileInfo);
                this.afterMultipartUpload(bucket, fileInfo, fileStorage);
            }
        }
        catch (MongoGridFSException e) {
            this.deleteFile(bucket, fileInfo);
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, fileInfoId);
        }
        catch (BusinessException e) {
            this.deleteFile(bucket, fileInfo);
            throw e;
        }
    }

    public void coverEmptyFile(String bucket, String fileInfoId) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        if (fileInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{fileInfoId});
        }
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        fileStorage.deleteFile(fileInfo);
        this.afterFileDeleted(bucket, fileInfo);
        fileStorage.createFile(fileInfo);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public FileInfo coverUploadFromStream(String bucket, String fileInfoId, InputStream source) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileInfoId);
        try {
            FileInfo oldFileInfo = fileInfo.clone();
            fileInfo.setSize(0L);
            fileInfo.setFileId(null);
            FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
            HashingUploadWrapper.of().uploadFromStream(fileStorage, fileInfo, source);
            this.afterCoverUpload(bucket, fileInfo, oldFileInfo.getSize(), fileStorage);
            this.backupCrudService.addBackup(bucket, oldFileInfo);
            return fileInfo;
        }
        catch (MongoGridFSException e) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, fileInfoId);
        }
    }

    public void editUpload(String bucket, FileCallbackData extra, InputStream source) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, extra.getFileId());
        try {
            FileInfo oldFileInfo = fileInfo.clone();
            fileInfo.setSize(extra.getSize().longValue());
            fileInfo.setFileId(null);
            FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
            HashingUploadWrapper.of().uploadFromStream(fileStorage, fileInfo, source);
            this.afterEditUpload(bucket, fileInfo, oldFileInfo.getSize(), fileStorage);
            this.backupCrudService.addBackup(bucket, oldFileInfo);
        }
        catch (MongoGridFSException e) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, extra.getFileId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileInfo uploadFromFile(String bucket, FileInfo fileInfo, MultipartFile multipart) {
        try (InputStream inputStream = multipart.getInputStream();){
            if (fileInfo.getFileName() == null) {
                fileInfo.setFileName(multipart.getOriginalFilename());
            }
            if (fileInfo.getExtension() == null) {
                fileInfo.setExtension(FileUtil.getExtension((String)fileInfo.getFileName()));
            }
            if (fileInfo.getContentType() == null && !"application/octet-stream".equals(multipart.getContentType())) {
                fileInfo.setContentType(multipart.getContentType());
            }
            fileInfo.setSize(multipart.getSize());
            this.uploadFromStream(bucket, fileInfo, inputStream);
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, fileInfo.getFileName());
        }
    }

    public FileInfo uploadFromStream(String bucket, FileInfo fileInfo, InputStream source) {
        try {
            this.fidCheckService.fillAndCheck(bucket, fileInfo);
            if (fileInfo == null) {
                return null;
            }
            FileStorage fileStorage = this.fileStorageFactory.selectStorage(bucket, fileInfo);
            HashingUploadWrapper.of().uploadFromStream(fileStorage, fileInfo, source);
            this.afterFileUpload(bucket, fileInfo, fileStorage);
            return fileInfo;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(I18nError.FILE_UPLOAD_FAIL.getMessage(new Object[]{fileInfo.getFileName()}), (Throwable)e);
        }
    }

    public FileInfo uploadFromBytes(String bucket, FileInfo fileInfo, byte[] source) {
        FileStorage fileStorage = this.fileStorageFactory.selectStorage(bucket, fileInfo);
        HashingUploadWrapper.of().uploadFromBytes(fileStorage, fileInfo, source);
        this.afterFileUpload(bucket, fileInfo, fileStorage);
        return fileInfo;
    }

    public UploadStatus getFileUploadStatus(String bucket, String fileInfoId) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileInfoId);
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        long fileLength = fileStorage.getFileSize(fileInfo);
        return new UploadStatus(fileLength, fileInfo.getSize());
    }

    public void deleteFile(String bucket, FileInfo fileInfo) {
        if (fileInfo == null || fileInfo.getFileId() == null) {
            return;
        }
        long count = this.fileInfoCrudService.count(bucket, fileInfo.getId(), fileInfo.getFileId());
        if (count < 1L) {
            FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
            fileStorage.deleteFile(fileInfo);
            this.afterFileDeleted(bucket, fileInfo);
        }
    }

    private void afterFileDeleted(String bucket, FileInfo fileInfo) {
        fileInfo.setBucket(bucket);
        this.fileLogService.fileOpLog(FileOp.Delete, fileInfo);
        this.bucketService.dealBucketSize(bucket, -fileInfo.getSize(), -1);
    }

    private void afterFileUpload(String bucket, FileInfo fileInfo, FileStorage fileStorage) {
        if (fileInfo == null || fileInfo.getId() == BaseField.EMPTY_UUID) {
            this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u56fe\u7247\u5904\u7406\u670d\u52a1", (Object)fileInfo);
            return;
        }
        long fileSize = fileStorage.getFileSize(fileInfo);
        fileInfo.setSize(fileSize);
        fileInfo.setCompleted(Boolean.TRUE);
        this.fileInfoCrudService.insert((UuIdEntity)fileInfo);
        this.fileLogService.fileOpLog(FileOp.Upload, fileInfo);
        this.bucketService.dealBucketSize(bucket, fileInfo.getSize(), 1);
    }

    private void afterMultipartUpload(String bucket, FileInfo fileInfo, FileStorage fileStorage) {
        long fileSize = fileStorage.getFileSize(fileInfo);
        fileInfo.setSize(fileSize);
        fileInfo.setCompleted(Boolean.TRUE);
        fileInfo.setCoverDate(LocalDateTime.now());
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.replace((UuIdEntity)fileInfo);
        this.fileLogService.fileOpLog(FileOp.Multipart, fileInfo);
        this.bucketService.dealBucketSize(bucket, fileInfo.getSize(), 1);
    }

    private void afterCoverUpload(String bucket, FileInfo fileInfo, long oldSize, FileStorage fileStorage) {
        long fileSize = fileStorage.getFileSize(fileInfo);
        fileInfo.setSize(fileSize);
        fileInfo.setCompleted(Boolean.TRUE);
        fileInfo.setCoverDate(LocalDateTime.now());
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        this.fileLogService.fileOpLog(FileOp.Cover, fileInfo);
        this.bucketService.dealBucketSize(bucket, fileSize - oldSize, 0);
    }

    private void afterEditUpload(String bucket, FileInfo fileInfo, long oldSize, FileStorage fileStorage) {
        if (fileInfo.getSize() == 0L) {
            long fileSize = fileStorage.getFileSize(fileInfo);
            fileInfo.setSize(fileSize);
        }
        fileInfo.setCompleted(Boolean.TRUE);
        fileInfo.setModifyDate(LocalDateTime.now());
        fileInfo.setBucket(bucket);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        this.fileLogService.fileOpLog(FileOp.Edit, fileInfo);
        this.bucketService.dealBucketSize(bucket, fileInfo.getSize() - oldSize, 0);
    }
}

