/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.login;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.service.login.LoginService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginContext {
    @Autowired
    private List<LoginService> loginServices;

    public String login(LoginUser loginUser) {
        for (LoginService userTokenService : this.loginServices) {
            if (!userTokenService.support(loginUser)) continue;
            return userTokenService.login(loginUser);
        }
        return null;
    }

    public String refresh(String userToken, String tenantId) {
        for (LoginService userTokenService : this.loginServices) {
            if (!userTokenService.validate(userToken)) continue;
            return userTokenService.refresh(userToken, tenantId);
        }
        return null;
    }

    public JwtUser analysis(String userToken, HttpServletRequest request) {
        for (LoginService userTokenService : this.loginServices) {
            if (!userTokenService.validate(userToken)) continue;
            return userTokenService.analysis(userToken, request);
        }
        throw new BusinessException((ErrorHandler)I18nError.LOGIN_TOKEN_INVALID, userToken);
    }
}

