/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.login.impl;

import com.digiwin.dap.middleware.auth.LoginInfo;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserType;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.obsolete.service.BucketUserService;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.login.LoginService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginType;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginUser;
import com.digiwin.dap.middleware.dmc.support.remote.IamService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.support.DapHttpService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=2)
@Service
public class LoginIamServiceImpl
implements LoginService {
    @Autowired
    private IamService iamService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private BucketUserService bucketUserService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private DapHttpService dapHttpService;

    public boolean support(LoginUser loginUser) {
        return loginUser.getLoginType() == LoginType.iam;
    }

    public boolean validate(String token) {
        try {
            IdUtil.uuid((String)token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String login(LoginUser loginUser) {
        return this.iamService.getUserToken(loginUser);
    }

    public String refresh(String token, String tenantId) {
        if ("default".equals(tenantId)) {
            return token;
        }
        return this.iamService.getUserToken(token, tenantId);
    }

    public JwtUser analysis(String token, HttpServletRequest request) {
        LoginInfo iamUser;
        ArrayList buckets = new ArrayList();
        if (this.envProperties.isCoa()) {
            iamUser = this.iamService.getIamUser(token);
            List tenantIds = this.iamService.getTenantIds(token);
            buckets.addAll(tenantIds);
        } else {
            iamUser = this.dapHttpService.tokenAnalyze(request);
        }
        JwtUser jwtUser = JwtUser.initUser((LoginInfo)iamUser);
        jwtUser.setToken(token);
        jwtUser.setDeployArea(this.envProperties.getDeployArea());
        buckets.addAll(this.bucketUserService.findBuckets(jwtUser.getUserId(), UserType.IAM.ordinal()));
        jwtUser.getBuckets().addAll(buckets);
        User user = this.userRepository.findByName(jwtUser.getUserId());
        if (user != null) {
            jwtUser.initRole(user.getBuiltinRole());
        }
        return jwtUser;
    }
}

