/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.login.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserType;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.obsolete.service.BucketUserService;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.login.LoginService;
import com.digiwin.dap.middleware.dmc.service.login.token.UserTokenService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginType;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=1)
@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private BucketUserService bucketUserService;

    public boolean support(LoginUser loginUser) {
        return loginUser.getLoginType() == null || loginUser.getLoginType() == LoginType.token;
    }

    public boolean validate(String token) {
        return this.userTokenService.validate(token);
    }

    public String login(LoginUser loginUser) {
        User user = this.userRepository.findByName(loginUser.getUsername());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NONE, new Object[]{loginUser.getUsername()});
        }
        if (!Objects.equals(loginUser.getPwdhash(), user.getPwdHash())) {
            return null;
        }
        this.userRepository.loginCount(user.getId());
        JwtUser jwtUser = JwtUser.initUser((User)user, (String)loginUser.getTenantId());
        jwtUser.setDeployArea(this.envProperties.getDeployArea());
        return this.userTokenService.getToken(jwtUser);
    }

    public String refresh(String token, String tenantId) {
        JwtUser jwtUser = (JwtUser)this.userTokenService.getData(token);
        this.temp(jwtUser);
        jwtUser.setTenantId(tenantId);
        return this.userTokenService.getToken(jwtUser);
    }

    public JwtUser analysis(String token, HttpServletRequest request) {
        JwtUser jwtUser = (JwtUser)this.userTokenService.getData(token);
        this.temp(jwtUser);
        jwtUser.setToken(token);
        List buckets = this.bucketUserService.findBuckets(jwtUser.getUserId(), UserType.ADMIN.ordinal());
        jwtUser.getBuckets().addAll(buckets);
        return jwtUser;
    }

    @Deprecated
    private void temp(JwtUser jwtUser) {
        if (StrUtils.isEmpty((String)jwtUser.getVersion())) {
            jwtUser.setUserId(jwtUser.getUsername());
        }
    }
}

